#import <AppKit/AppKit.h>


@class ActionEngine, Engine, Interface, BundleMain;

extern NSString *engineKey;
extern NSString *moduleKey;
extern NSString *titleKey;
extern NSString *dateKey;


@interface EngineData:NSObject <NSCopying, NSCoding, NSMutableCopying>
{
	NSMutableDictionary		*dict;
	NSString				*helper;
}

- (id)objectForKey: (id)key;
- (void)setObject: (id)object forKey: (id)key;
- (void)removeObjectForKey:(id)key;

- (void) setComment:(NSString *)comm;
- (NSString *) comment;

- (BOOL)boolForKey: (id)key;
- (void)setBool: (BOOL)b  forKey: (id)key;

- (double)doubleForKey: (id)key;
- (void)setDouble: (double)d  forKey: (id)key;

- (int)intForKey: (id)key;
- (void)setInt: (int)i  forKey: (id)key;

- (NSColor *)colorForKey: (id)key;
- (void)setColor: (NSColor *)c  forKey: (id)key;

- (void) touch;
- (NSDate *) lastModified;

@end
