/* OutputManager.h created by stanj on Fri 15-May-1998 */

#import <AppKit/AppKit.h>

#import "OutputProvider.h"


@interface OutputManager : NSObject
{
	NSMutableArray		*providers;
}

+ sharedInstance;

- (void)registerOutputProvider:(OutputProvider *)op;
- (NSArray *)outputProviders;

- (NSArray *)outputFormatDescriptions;
- (NSArray *)localizedOutputFormatDescriptions;

- (id <DocumentWriter>)writerForFormatDescription:(NSString *)desc;
- (OutputProvider *)providerForDescription:(NSString *)desc;

- (NSBox *)customViewForFormatDescription:(NSString *)desc;
- (NSString *)extensionForFormatDescription:(NSString *)desc;
- (NSDictionary *)currentParametersForFormatDescription:(NSString *)desc;
- (NSDictionary *)defaultParametersForFormatDescription:(NSString *)desc;

- (int)indexOfBestProviderForFileNamed:(NSString *)name;
- (OutputProvider *)providerAtIndex:(int)i;

@end
