/* OutputProvider.h created by stanj on Fri 15-May-1998 */

#import <AppKit/AppKit.h>

#import "Document.h"
#import "DocumentWriter.h"


// output provider is a manager class providing at least one
// output writer to the application. it manages requests from
// the app, as well as user interface elements.

@interface OutputProvider : NSObject
{
	id			boxesPanel;	// will automatically be freed
}

// designated initializer
// loads by default [className].nib for you
- init;

// each provider can register only one path extension
// if you need more that one extension, you must provide
// several output providers.
- (NSString *)outputFormatExtension;
- (NSArray *)outputFormatExtensions;

// each format must have a unique description so that it can
// be uniquely identified by the ouptut manager. this array of
// NSStrings will NOT be show to the user, it will be used
// only for internal encoding.
// by default, the propertly list "[className].plist" is searched
// with the "OutputFormatDescriptions" key.
- (NSArray *)outputFormatDescriptions;

// the array of localized strings for the above formats.
- (NSArray *)localizedOutputFormatDescriptions;

- (NSBox *)customViewForFormatDescription:(NSString *)desc;
- (NSDictionary *)currentParametersForFormatDescription:(NSString *)desc;
- (NSDictionary *)defaultParametersForFormatDescription:(NSString *)desc;
- (void)setupCustomViewFromParameters:(NSDictionary *)params;

- (id <DocumentWriter>)writerForFormatDescription:(NSString *)description;

@end
