#import <AppKit/AppKit.h>
#import "PixelSource.h"


@interface PixelCache: NSObject  <PixelSource>
{
	id <PixelSource>	  source;

	int				  pixelsWide;
	int				  pixelsHigh;
	int				  cacheHeight;

	WrapMode			  wrapMode;
	SEL				  rgbSEL, cmykSEL;

	void				(*getRGB)(id <PixelSource>,SEL, RGBAPixel *,
						int,int, int);
	void				(*getCMYK)(id <PixelSource>,SEL, CMYKAPixel *,
						int,int, int);

	RGBAPixel			 *rgba;
	CMYKAPixel		 *cmyka;

	int				 *row;
	int				 *colMin;
	int				 *colMax;
}

- init;
- initWithSource: (id <PixelSource>)source;
- (void)dealloc;

- (void)setSource: (id <PixelSource>)source;
- (id <PixelSource>)source;

- (void)setWrapMode: (WrapMode)wrapMode;
- (WrapMode)wrapMode;

- (void)hintCacheSize: (int)s;

- (void)getRGBAPixel: (RGBAPixel *)p  at: (int)x: (int)y  count: (int)n;
- (void)getCMYKAPixel: (CMYKAPixel *)p  at: (int)x: (int)y  count: (int)n;

- (double)dpi;

- (int)width;
- (int)height;

- (BOOL)isCMYKA;

@end
