// Copyright 1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OATabViewController.h"

#import <AppKit/AppKit.h>
#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniAppKit/Widgets.subproj/OATabViewController.m,v 1.6 1998/12/08 04:07:30 kc Exp $")

#ifdef RHAPSODY

@interface OATabViewController (Private)
@end

@implementation OATabViewController

//
// API
//

- (NSString *)label;
{
    return nil;
}

- (unsigned int)sequenceNumber;
{
    return 0;
}

- (NSWindowController *)windowController;
{
    return [[tabView window] windowController];
}

- (NSDocument *)document;
{
    return [[self windowController] document];
}

- (void)refreshUserInterface;
{

}

//
// NSNibAwaking informal protocol
//

- (void)awakeFromNib;
{
    NSView *contentView, *initialFirstResponder;
    NSTabViewItem *tabViewItem;
    unsigned int tabIndex, tabCount;

    if (flags.alreadyAwoke)
        return;
    flags.alreadyAwoke = YES;
    
    tabViewItem = [[NSTabViewItem alloc] initWithIdentifier:self];
    [tabViewItem setLabel:[self label]];

    initialFirstResponder = [scratchWindow initialFirstResponder];
        
    contentView = [scratchWindow contentView];
    [contentView setAutoresizesSubviews:YES];
    [contentView setAutoresizingMask:NSViewWidthSizable | NSViewHeightSizable];
    [tabViewItem setView:contentView];

    [tabViewItem setInitialFirstResponder:initialFirstResponder];

    tabCount = [tabView numberOfTabViewItems];
    for (tabIndex = 0; tabIndex < tabCount; tabIndex++) {
        if ([(OATabViewController *)[[tabView tabViewItemAtIndex:tabIndex] identifier] sequenceNumber] > [self sequenceNumber]) {
            [tabView insertTabViewItem:tabViewItem atIndex:tabIndex];
            break;
        }
    }
    
    if (tabIndex == tabCount)
        [tabView addTabViewItem:tabViewItem];

    [tabView selectFirstTabViewItem:nil];

    [tabViewItem release];
}


//
// NSMenuValidation informal protocol
//

- (BOOL)validateMenuItem:(NSMenuItem *)anItem
{
    return YES;
}


@end

@implementation OATabViewController (Private)
@end

#endif
