// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniAppKit/Widgets.subproj/OAThumbnailView.h,v 1.6 1998/12/09 21:58:11 kc Exp $

#import <AppKit/NSView.h>

@interface OAThumbnailView : NSView
{
    NSArray	*thumbnails;
    NSSize	 maximumThumbnailSize;
    NSSize	 padding;
    int		 columnCount, rowCount;
    NSSize	 cellSize;
    float	 horizontalMargin;
    
    BOOL	 thumbnailsAreNumbered;
}

- (void)scrollSelectionToVisible;

- (void)setThumbnailsArray:(NSArray *)newThumbnailsArray;
- (NSArray *)thumbnailsArray;
- (void)sizeToFit;

- (void)setThumbnailsNumbered:(BOOL)bool;
- (BOOL)thumbnailsAreNumbered;

- (void)drawMissingThumbnailRect:(NSRect)rect;

@end


@protocol OmniThumbnailProvider
- (NSImage *)thumbnailImage;
- (void)missedThumbnailImageInView:(OAThumbnailView *)view
    rect:(NSRect)rect;
- (NSSize)thumbnailSize;
- (void)thumbnailWasSelected:(NSEvent *)event;
- (BOOL)isThumbnailSelected;
@end
