/* 
	TableOfContents.m created by dirk on Thu 02-Dec-1999
*/
#import <Foundation/Foundation.h>
#import "TableOfContents.h"

#define _MAILTOC_DEFINES 1
#import "mailtoc.h"

@implementation TableOfContents : NSObject

- (id)initWithMailboxPath:(NSString *)mboxPath
/*"
This is the default initializer.
"*/
{    
	[super init];
    ivTocFileName = [[mboxPath stringByAppendingPathComponent:@"table_of_contents"] retain];
    return self;
}

- (void)dealloc
{
    [ivTocFileName release];
    [super dealloc];
}

- (NSCalendarDate *)modificationDate
{
    return [[[NSFileManager defaultManager] fileAttributesAtPath:ivTocFileName traverseLink:YES] objectForKey:NSFileModificationDate];
}

- (BOOL)hasUnreadMails
{
    FILE		*fp;
    int			i;
    struct table_of_contents_header	*mailToc;
    struct message_index	*msgIndex;
	BOOL		unreadMails = NO;
    
#ifdef DEBUG
    NSLog(@"%@ [%@] opened toc", ivTocFileName, [[NSCalendarDate calendarDate] descriptionWithCalendarFormat:@"%H:%M:%S.%F"]);
#endif
	
    fp = fopen([ivTocFileName cString], "r");
    NSAssert1(fp != NULL, @"Cannot open file: %@", ivTocFileName);
	// get the number of messages in the mbox
    mailToc = get_table_of_contents_header(fp, 0);
    ivNumberOfMessages = mailToc->num_msgs;
    free(mailToc);
    
    // read all toc entries
    for (i = 0; i < ivNumberOfMessages; i++)
    {
        msgIndex = get_message_index(fp);
        NSAssert1(msgIndex != 0, @"Premature EOF while reading mail record in table_of_contents file: %@", ivTocFileName);

        if (msgIndex->status == MT_STATUS_NEW)
        {
            unreadMails = YES;
            free(msgIndex);
            break;
        }
        free(msgIndex);
    }

    fclose(fp);
#ifdef DEBUG
    NSLog(@"%@ [%@] closing toc", ivTocFileName, [[NSCalendarDate calendarDate] descriptionWithCalendarFormat:@"%H:%M:%S.%F"]);
#endif
    return unreadMails;
}

@end
