
#import <AppKit/NSView.h>
#import "SaverView.h"

typedef struct { float l,b,r,t;	} BRECT;

typedef struct { 
	float hue;
	float pos;
	} LineInfo;

// maximum number number of grid lines
#define NVERT 8
#define NHORIZ 10

#define DECREASING 0
#define INCREASING 1

void horizLineWithAvoidance(float x1, float y1, float x2,float y2,
			float hue,float brightness, const NSRect *r);

void verticalLineWithAvoidance(float x1, float y1, float x2,float y2,
			float hue,float brightness, const NSRect *r);

@interface BoinkView:SaverView
{
	float	xpos;
	float	xspeed;
	float	ypos;
	float	yspeed;
	float	accel;
	int	ballNum;
	int	spinDir;
	int rebound;

	float viewHeight;
	float viewWidth;

	BRECT old;
	NSPoint ballTo;
	NSPoint redrawTo;
	NSRect redraw;
	NSSize oldSize;
	
	id buffer;
	id balls;
	
	int nvert, nhoriz;
	int vcount, hcount;
	LineInfo vertLines[NVERT];
	LineInfo horizLines[NHORIZ];
	int toggle;
	int reboundMode;
	float lastLaunchSpeed;

	unsigned now, then;
	unsigned nextRotationTime;
	unsigned nextLineDrawTime;
}

- oneStep;
- newSpeed;
- initWithFrame:(NSRect)frameRect;
- setAccel:(float)val;
- (void)setFrameSize:(NSSize)_newSize;
- (void)drawRect:(NSRect)rects;
- newViewSize;
- incrementBallNumber;
- (float) getRandomXspeed;
- (float) timeCorrectedXSpeed;
- checkXspeed:(float *)speed;
- (const char *)windowTitle;
- updateGrid;
- drawGrid;
- drawLinesInBuffer;

@end
