//  OpenGLView.m
//
//  You may freely copy, distribute, and reuse the code in this example.
//  ESP disclaims any warranty of any kind, expressed or  implied, as to its
//  fitness for any particular use.


#import "OpenGLView.h"

@implementation OpenGLView

- (NSString *)_nibName
{
	return [NSString stringWithCString:"OpenGL"];
}	

- (void)_initOpenGL
{
	return;
}

- (void)_drawOpenGL
{
	return;
}

- (void)_reshapeOpenGL:(int) width :(int)height
{
	return;
}			

- (void)_createViewport
{
    		if(buffer)
      			free(buffer);
    		buffer=malloc(gl_width*gl_height*4);

    		if(ctx)
      			OSMesaDestroyContext(ctx);
    
    		ctx = OSMesaCreateContext( GL_RGBA, NULL );
    		OSMesaMakeCurrent( ctx, buffer, GL_UNSIGNED_BYTE,
                       gl_width, gl_height );
    		OSMesaPixelStore( OSMESA_Y_UP, 0 );
		
		[self _initOpenGL];
		
		return;

}

- (void)_renderImage
{
	NSBitmapImageRep *bitmap;
 
	[self _drawOpenGL];
	
	// Fill the bitmap with the buffer
 	
	bitmap = [[ NSBitmapImageRep alloc]
				 initWithBitmapDataPlanes: &buffer
				 pixelsWide:gl_width
				 pixelsHigh:gl_height
				 bitsPerSample:8
				 samplesPerPixel:4
				 hasAlpha:YES
				 isPlanar:NO
				 colorSpaceName: NSDeviceRGBColorSpace
				 bytesPerRow: 0 //gl_width*4
                                 bitsPerPixel: 0]; //(int)32];

	
	//NSDrawBitmap(*&bounds,gl_width, gl_height, 8, 4, 32, gl_width*4, NO, YES, 2, &buffer);


        [bitmap draw];
	[bitmap release];
}

- initWithFrame:(const NSRect)frameRect
{
	[super initWithFrame:frameRect];
	[self allocateGState];		// For faster lock/unlockFocus
	//[self setClipping:NO];		// even faster...
		
	gl_width = frameRect.size.width;
	gl_height = frameRect.size.height;
	

	[self _createViewport];
	
	[self _reshapeOpenGL:gl_width :gl_height];
	
	return self;
}

- oneStep
{
	[self _renderImage];
	
	return self;
}

- (void)drawRect:(NSRect)rect 
{
	//if (!rects) return self;
	
	PSsetgray(0);
	NSRectFill(rect);

        [self oneStep];


	return;
}
	

- (void)dealloc
{
    	OSMesaDestroyContext(ctx);
    	free(buffer);
        [super dealloc];
       	return;
}

- (void)setFrameSize:(NSSize)aSize
{
	[super setFrameSize:aSize];
	gl_width = aSize.width;
	gl_height = aSize.height;
	
	[self _createViewport];
	
	[self _reshapeOpenGL:gl_width :gl_height];

	return;
}

- inspector:sender
{	
    	if (!sharedInspectorPanel){
                return nil;
   	}
        return sharedInspectorPanel;
}

- updateSelection:sender
{
	[self _createViewport];
	
	[self _reshapeOpenGL:gl_width :gl_height];

	return self;
}
	
		
@end
