#import "CCCCObject.h"

@implementation CCCCObject


- (void)applicationDidFinishLaunching:(NSNotification *)notification
// In order for your object to receive this notification make sure that
// your object is a delegate or "File's Owner" in IB.
// Connected from "File's Owner" to MenuObject in this case.
{

    [TheWindow makeKeyAndOrderFront:NULL];
    [CCnumber selectText:self];
}


- (void)CheckIt:(id)sender
{
    // This program is based on cc_cksum. Credit Card check sum program
    // from 2600 magazine.
    //
    // Adapted for OpenStep by Eric Tremblay June 29, 1997

    // Local Variables
    const char *cc;
    int check, len, prod, j;

    	// Assign the value in the panel to the cc variable.
        cc = [[CCnumber stringValue] cString];
    
        if (cc[0] != '3' && cc[0] != '4' && cc[0] != '5' && cc[0] != '6') {
            [Status setStringValue:@"Card number must start with 3, 4, 5, or 6."];
            [Status setTextColor:[NSColor purpleColor]];
            [CCnumber selectText:self]; 
            return;
        }

        // Counts the string length of the cc variable.
        len = strlen(cc);

        
        if (cc[0] == '5' && len != 16) {
            [Status setStringValue:@"Mastercard must be 16 digits."];
            [Status setTextColor:[NSColor orangeColor]];
            [CCnumber selectText:self]; 
            return;
        }

        
        if (cc[0] == '4' && (len != 13 && len != 16)) {
            [Status setStringValue:@"Visa numbers must be 13 or 16 digits."];
            [Status setTextColor:[NSColor orangeColor]];
            [CCnumber selectText:self]; 
            return;
        }

        
        if (cc[0] == '3' && len != 15) {
            [Status setStringValue:@"American Express numbers must be 15 digits."];
            [Status setTextColor:[NSColor orangeColor]];
            [CCnumber selectText:self]; 
            return;
        }

        
        if (cc[0] == '6' && len != 16) {
            [Status setStringValue:@"Discover numbers must be 16 digits."];
            [Status setTextColor:[NSColor orangeColor]];
            [CCnumber selectText:self]; 
            return;
        }

        
        //  Perform checksum - Weighing list 212121212121...
        check = 0;
        for (j = 0; j < len; ++j) {
            prod = cc[j] - '0';
            if (((len - (j + 1)) %2)) {
                prod *= 2;
            }
            if (prod >= 10) {
                prod = prod - 9;
            }
            check += prod;
        }
        
        if ((check % 10) == 0) {
            [Status setStringValue:@"Card has good checksum"];
            [Status setTextColor:[NSColor greenColor]];
            [CCnumber selectText:self]; 
        } else {
            [Status setStringValue:@"Card has BAD checksum"];
            [Status setTextColor:[NSColor redColor]];
            [CCnumber selectText:self]; 
        }
        
}

- (void)InfoPanel:(id)sender
{

    [NSBundle loadNibNamed:@"InfoPanel.nib" owner:self]; // load nib
    
}

- (void)IntroAndHelp:(id)sender
{

    [NSBundle loadNibNamed:@"HelpIntro.nib" owner:self]; // load nib
    
}

- (void)MoreInfo:(id)sender
{

    [NSBundle loadNibNamed:@"MoreInfo.nib" owner:self]; // load nib
    
}

- (void)ClearStatus:(id)sender
{

    [Status setStringValue:@"Hello World!!!"];

}

@end
