/********************************************************************************

File:      CustomPageLayout.m

This is a subclass of NSPageLayout, and implements a version of PageLayout that
knows about our additional pagination options.  The additional features are set
using an accessory view.  Instead of subclassing a panel, you should usually
just have a controller object for the accessory view, but NSPageLayout doesn't
provide a way for the accessory view to add to the PageInfo record.

This sample is based on a NeXTSTEP 3.3 sample written by Samuel Streeper.

Written by: Timothy Carroll

Created:    Wed 15-Oct-1997

Copyright:  (c) 1991, 1997 by Apple Computer, Inc., all rights reserved.

Change History (most recent first):

You may incorporate this sample code into your applications without
restriction, though the sample code has been provided "AS IS" and the
responsibility for its operation is 100% yours.  However, what you are
not permitted to do is to redistribute the source as "DSC Sample Code"
after having made changes. If you're going to re-distribute the source,
we require that you make it clear in the source that the code was
descended from Apple Sample Code, but that you've made changes.
********************************************************************************/


#import "CustomPageLayout.h"
id	gCustomPagePanel;
id	gCustomPageAccessory;
@implementation CustomPageLayout

+ (id) customLayout
{
	id printInfo;
	if (gCustomPagePanel == NULL)
	{
		// allocate our custom PrintInfo record and page panel.
		printInfo = [[CustomPrintInfo alloc] init];
		[NSPrintInfo setSharedPrintInfo: printInfo];

		gCustomPagePanel = [[CustomPageLayout alloc] init];
	}
	return gCustomPagePanel;
}

- (int) runModal
{
	if (customOptionsView == NULL)
	{
		if ([NSBundle loadNibNamed: @"PagePanel.nib" owner:self])
		{
			[self setAccessoryView: customOptionsView];
		}
		else
		{
			NSLog(@"Failed to load customOptionsNib");
			NSBeep();
			return NSCancelButton;
		}
        }

	return [super runModal];
}

// The units have changed, so we need to update our cells for the margins
- (void) pickedUnits:(id)sender
{
	float old, new;
	id cell;

	[self convertOldFactor: &old newFactor: &new];

	cell = 	[margins cellAtRow: 0 column: 0];
	[cell setFloatValue: new * [cell floatValue] / old];

	cell = 	[margins cellAtRow: 1 column: 0];
	[cell setFloatValue: new * [cell floatValue] / old];

	cell = 	[margins cellAtRow: 2 column: 0];
	[cell setFloatValue: new * [cell floatValue] / old];

	cell = 	[margins cellAtRow: 3 column: 0];
	[cell setFloatValue: new * [cell floatValue] / old];

	return [super pickedUnits: sender];
}

// Read the information from the PrintInfo record, and reflect
// those values in the accessory view.

- (void) readPrintInfo
{
    float	conversion, dummy;
    float	left, right, top, bottom;
    id		printInfo;

    [super readPrintInfo];
    printInfo = [NSPrintInfo sharedPrintInfo];

    [[centerButtons cellAtRow:0 column:0]
        setState:[printInfo isHorizontallyCentered]];
    [[centerButtons cellAtRow:1 column:0]
        setState:[printInfo isVerticallyCentered]];

    [vertButtons selectCellAtRow:[printInfo verticalPagination] column: 0];
    [horButtons selectCellAtRow: [printInfo horizontalPagination] column: 0];
    [paginationButtons selectCellAtRow:[printInfo paginationMode] column: 0];

    [self convertOldFactor:&conversion  newFactor: &dummy];

    left = [printInfo leftMargin];
    right = [printInfo rightMargin];
    top = [printInfo topMargin];
    bottom = [printInfo bottomMargin];

    [[margins cellAtRow:0 column:0] setFloatValue:left * conversion];
    [[margins cellAtRow:1 column:0] setFloatValue:right * conversion];
    [[margins cellAtRow:2 column:0] setFloatValue:top * conversion];
    [[margins cellAtRow:3 column:0] setFloatValue:bottom * conversion];
}


// Write our custom values out to the PrintInfo record.
- (void) writePrintInfo
{
    id printInfo;
    float conversion, dummy;

    [super writePrintInfo];
    printInfo = [NSPrintInfo sharedPrintInfo];

    [self convertOldFactor:&conversion newFactor:&dummy];

    // back convert our margins into points for the printInfo record
    [printInfo setLeftMargin:
	[[margins cellAtRow:0 column:0] floatValue]/ conversion];
    [printInfo setRightMargin:
        [[margins cellAtRow:1 column:0] floatValue]/ conversion];
    [printInfo setTopMargin:
        [[margins cellAtRow:2 column:0] floatValue]/ conversion];
    [printInfo setBottomMargin:
        [[margins cellAtRow:3 column:0] floatValue]/ conversion];

    [printInfo setHorizontallyCentered: 
	[[centerButtons cellAtRow:0 column:0] state]];
    [printInfo setVerticallyCentered:
	[[centerButtons cellAtRow:1 column:0] state]];

    [printInfo setVerticalPagination: [vertButtons selectedRow]];
    [printInfo setHorizontalPagination: [horButtons selectedRow]];

    [printInfo setPaginationMode: [paginationButtons selectedRow]];
}


@end
