static void *rcs_id = (rcs_id, "$Header: /Network/Developer/Source/CVS/OmniGroup/OmniCVSEOModelerBundle/CVSManager.m,v 1.7 1999/03/16 14:18:56 andrew Exp $");

/* CVSManager.m created by andrew on Wed 13-Nov-1996 */


#import <Foundation/Foundation.h>
#import <EOModeler/EOModeler.h>

#import "CVSManager.h"


/* minor extension to NSFileManager to make it more convenient to see if a directory exists */

@interface NSFileManager (CVSBundleExtensions)
- (BOOL)directoryExistsAtPath:(NSString *)path;
@end

@implementation NSFileManager (CVSBundleExtensions)
- (BOOL)directoryExistsAtPath:(NSString *)path;
{
    BOOL isDirectory;

    if (![self fileExistsAtPath: path isDirectory: &isDirectory])
        return NO;
    return isDirectory;
}

@end


/*
   On +load we register for notification when a document is saved. When we get that notification, we try to copy the CVS info from the model's backup to the newly saved model.
*/

@interface CVSManager (Private)
+ (NSString *)restoreCVSInfoToDocumentAt:(NSString *)path;
+ (void)didSaveDocument:(NSNotification *)notification;
@end


@implementation CVSManager

static NSString *versionString = @"version 1.0";

+ (NSString *)versionString;	// in case we ever decide to display this somehow
{
    return versionString;
}

+ (void)load;
{
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(didSaveDocument:) name:EOMDocumentDidSaveNotification object:nil];
}

+ (NSString *)adjustEntriesFileInDirectory:(NSString *)basePath forModel:(EOModel *)aModel
//+ (NSString *)adjustEntriesFile:(NSString *)path forModel:(EOModel *)aModel
{
    NSMutableSet *entityNames, *fetchSpecNames, *procedureNames;
    NSMutableString *result;
    NSArray *entriesLines;
    NSEnumerator *enumerator, *remainder = nil;
    NSString *line, *remainderLine = nil;
    NSString *name;
    NSString *path;
    NSFileManager *fileManager;

    fileManager = [NSFileManager defaultManager];

    path = [[basePath stringByAppendingPathComponent:@"CVS"] stringByAppendingPathComponent:@"Entries"];

    result = [NSMutableString string];
    entityNames = [NSMutableSet setWithArray:[aModel entityNames]];
    procedureNames = [NSMutableSet setWithArray:[aModel storedProcedureNames]];
    entriesLines = [[NSString stringWithContentsOfFile:path] componentsSeparatedByString:@"\n"];

    // these aren't really fetch spec names, but names of entities with fetch specs
    fetchSpecNames = [NSMutableSet setWithArray:[aModel entityNames]];
    // remove any fetch spec names for which we don't have files
    enumerator = [entityNames objectEnumerator];
    while ((name = [enumerator nextObject])) {
        NSString *fetchSpecPath;

        fetchSpecPath = [[basePath stringByAppendingPathComponent:name] stringByAppendingPathExtension:@"fspec"];
        if (![fileManager fileExistsAtPath:fetchSpecPath])
            [fetchSpecNames removeObject:name];
    }

    /* Find removed entities */
    enumerator = [entriesLines objectEnumerator];
    while((line = [enumerator nextObject])) {
        NSArray *parts = [line componentsSeparatedByString:@"/"];

        if ([parts count] == 6) {
            name = [parts objectAtIndex:1];

            // entity
            if ([[name pathExtension] isEqualToString:@"plist"]) {
                NSString *version;

                version = [parts objectAtIndex:2];
                name = [name stringByDeletingPathExtension];
                
                if ([entityNames member:name]) {
                    // we have an entity in the Entries file; make sure it's not marked for CVS removal
                    [entityNames removeObject:name];
                    if ([version characterAtIndex:0] == '-') {
                        NSMutableArray *mutable = [parts mutableCopy];

                        [mutable replaceObjectAtIndex:2 withObject:[version substringFromIndex:1]];
                        line = [mutable componentsJoinedByString:@"/"];
                        [mutable release];
                    }
                } else {
                    // we have an entry in the Entries file with no corresponding entity; make sure it's marked for CVS removal
                    if ([version isEqualToString:@"0"])
                        line = nil;
                    else if ([version characterAtIndex:0] != '-') {
                        NSMutableArray *mutable = [parts mutableCopy];

                        [mutable replaceObjectAtIndex:2 withObject:[@"-" stringByAppendingString:version]];
                        line = [mutable componentsJoinedByString:@"/"];
                        [mutable release];
                    }
                }

            // fetch specifications
            } else if ([[name pathExtension] isEqualToString:@"fspec"]) {
                name = [name stringByDeletingPathExtension];
                if ([fetchSpecNames member:name])
                    [fetchSpecNames removeObject:name];
                else {
                    NSString *version = [parts objectAtIndex:2];

                    if ([version isEqualToString:@"0"]) {
//                        NSLog (@"Deleting CVS entry for %@.fspec (was marked for addition but was never committed and has now been removed)", name);
                        line = nil;
                    } else {
                        NSMutableArray *mutable = [parts mutableCopy];

//                        NSLog (@"Marking %@.fspec for removal from CVS", name);
                        [mutable replaceObjectAtIndex:2 withObject:[@"-" stringByAppendingString:version]];
                        line = [mutable componentsJoinedByString:@"/"];
                        [mutable release];
                    }
                }
                
            // stored procedures
            } else if ([[name pathExtension] isEqualToString:@"storedProcedure"]) {
                NSString *version;

                version = [parts objectAtIndex:2];
                name = [name stringByDeletingPathExtension];
                
                if ([procedureNames member:name]) {
                    // we have a stored procedure in the Entries file; make sure it's not marked for CVS removal
                    [procedureNames removeObject:name];
                    if ([version characterAtIndex:0] == '-') {
                        NSMutableArray *mutable = [parts mutableCopy];

                        [mutable replaceObjectAtIndex:2 withObject:[version substringFromIndex:1]];
                        line = [mutable componentsJoinedByString:@"/"];
                        [mutable release];
                    }
                } else {
                    // we have an entry in the Entries file with no corresponding stored procedure; make sure it's marked for CVS removal
                    if ([version isEqualToString:@"0"])
                        line = nil;
                    else {
                        NSMutableArray *mutable = [parts mutableCopy];

                        [mutable replaceObjectAtIndex:2 withObject:[@"-" stringByAppendingString:version]];
                        line = [mutable componentsJoinedByString:@"/"];
                        [mutable release];
                    }
                }
            }
            
            if (line) {
                [result appendString:line];
                [result appendString:@"\n"];
            }
        } else {
            remainder = enumerator;
            remainderLine = line;
        }
    }

    /* Find added entities */
    enumerator = [entityNames objectEnumerator];
    while((name = [enumerator nextObject])) {
        [result appendFormat:@"/%@.plist/0/Initial %@.plist//\n", name, name];
    }

    /* Find added fetch specifications */
    enumerator = [fetchSpecNames objectEnumerator];
    while((name = [enumerator nextObject])) {
//        NSLog (@"Marking %@.fspec for addition to CVS", name);
        [result appendFormat:@"/%@.fspec/0/Initial %@.fspec//\n", name, name];
    }

    /* Find added procedures */
    enumerator = [procedureNames objectEnumerator];
    while((name = [enumerator nextObject])) {
        [result appendFormat:@"/%@.storedProcedure/0/Initial %@.storedProcedure//\n", name, name];
    }

    /* Append on end */
    if (remainderLine) {
        do {
            [result appendString:remainderLine];
            [result appendString:@"\n"];
        } while((remainderLine = [remainder nextObject]));
    }
    [result writeToFile:path atomically:YES];
    return nil;
}

+ (NSString *)restoreCVSInfoToDocumentAt:(NSString *)path forModel:(EOModel *)aModel;
{
    NSFileManager *manager;
    NSString *cvsPath;
    NSString *oldPath;
    NSString *basePath;

    basePath = [path copy];

    manager = [NSFileManager defaultManager];

    if (![manager directoryExistsAtPath:path])
        return [NSString stringWithFormat:@"Could not find model at %@", path];

    oldPath = [path stringByAppendingString:@"~"];
    if (![manager directoryExistsAtPath:oldPath])
        return nil;	// backup won't exist if model being saved was brand new

    cvsPath = [oldPath stringByAppendingPathComponent:@"CVS"];
    if (![manager directoryExistsAtPath:cvsPath])
        return nil;	// no CVS info to copy - probably never been checked in

    path = [path stringByAppendingPathComponent:@"CVS"];
    if ([manager directoryExistsAtPath:path])
        return [NSString stringWithFormat:@"CVS directory already exists at %@", path];

    if (![manager movePath:cvsPath toPath:path handler:nil])
        return [NSString stringWithFormat:@"Failed to move '%@' to '%@'", cvsPath, path];

    path = [path stringByAppendingPathComponent:@"Entries"];
//    return [self adjustEntriesFile:path forModel:aModel];
    return [self adjustEntriesFileInDirectory:basePath forModel:aModel];
}

+ (void)didSaveDocument:(NSNotification *)notification;
{
    NSString *errorMsg;
    NSString *path;

    path = [(EOModelerDocument *)[notification object] documentPath];

    errorMsg = [self restoreCVSInfoToDocumentAt:path forModel:[(EOModelerDocument *)[notification object] model]];
    if (errorMsg)
        NSRunAlertPanel (nil, errorMsg, nil, nil, nil);
}

@end
