/*
 File:       MagnifyingGlassController.m

 Contains:   Source code for the MagnifyingGlassController class

 Written by: Eric Simenel

 Created:    July 1997

 Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

 Change History (most recent first):

 You may incorporate this sample code into your applications without
 restriction, though the sample code has been provided "AS IS" and the
 responsibility for its operation is 100% yours.  However, what you are
 not permitted to do is to redistribute the source as "DSC Sample Code"
 after having made changes. If you're going to re-distribute the source,
 we require that you make it clear in the source that the code was
 descended from Apple Sample Code, but that you've made changes.
*/

#import "MagnifyingGlassController.h"

@implementation MagnifyingGlassController

// so simple, no comments are really necessary...

- (void)awakeFromNib
{
    [self setAnchor:NSMakePoint(0, 0)];
    [self unlockImage:nil];
}

- (void)setAnchor:(NSPoint)point
{
    anchor = point;
}

- (void)setGlobalLocation:(NSPoint)point
{
    int roundedValue;
    globalLocation = point;
    roundedValue = globalLocation.x;
    [xGlobalLocation setStringValue:[NSString stringWithFormat:@"%+05.4d", roundedValue]];
    roundedValue = globalLocation.y;
    [yGlobalLocation setStringValue:[NSString stringWithFormat:@"%+05.4d", roundedValue]];
    roundedValue = globalLocation.x - anchor.x;
    [xAnchoredLocation setStringValue:[NSString stringWithFormat:@"%+05.4d", roundedValue]];
    roundedValue = globalLocation.y - anchor.y;
    [yAnchoredLocation setStringValue:[NSString stringWithFormat:@"%+05.4d", roundedValue]];
}

- (void)anchorMouseLocation:(id)sender
{
    [self setAnchor:globalLocation];
    [self setGlobalLocation:globalLocation];
}

- (BOOL)imageIsLocked
{
    return imageIsLocked;
}

- (void)lockImage:(id)sender
{
    imageIsLocked = YES;
}

- (void)unlockImage:(id)sender
{
    imageIsLocked = NO;
    [magnifiedView mouseMoved:nil];
}

- (BOOL)validateMenuItem:(id <NSMenuItem>)menuItem
{
    if ([menuItem action] == @selector(lockImage:)) return !imageIsLocked;
    if ([menuItem action] == @selector(unlockImage:)) return imageIsLocked;
    return YES;
}

@end
