//---------------------------------------------------------------------------------------
// created as NSString+Extensions.m by znek on Sat 03-Mar-2001
// $Id: NSString+XMLExtensions.m,v 1.2 2001/08/01 17:45:40 znek Exp $
//
//  Copyright (c) 2001 by Marcus Mller <znek@mulle-kybernetik.com>.
//  All rights reserved.
//
//  Permission to use, copy, modify and distribute this software and its documentation
//  is hereby granted under the terms of the GNU General Public License, version 2
//  as published by the Free Software Foundation, provided that both the copyright notice
//  and this permission notice appear in all copies of the software, derivative works or
//  modified versions, and any portions thereof, and that both notices appear in supporting
//  documentation, and that credit is given to Marcus Mller in all documents and publicity
//  pertaining to direct or indirect use of this code or its derivatives.
//
//  This is free software; you can redistribute and/or modify it under
//  the terms of the GNU General Public License, version 2 as published by the Free
//  Software Foundation. Further information can be found on the project's web pages
//  at http://www.mulle-kybernetik.com/software/MulleNewz
//
//  THIS IS EXPERIMENTAL SOFTWARE AND IT IS KNOWN TO HAVE BUGS, SOME OF WHICH MAY HAVE
//  SERIOUS CONSEQUENCES. THE COPYRIGHT HOLDER ALLOWS FREE USE OF THIS SOFTWARE IN ITS
//  "AS IS" CONDITION. THE COPYRIGHT HOLDER DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY
//  DAMAGES WHATSOEVER RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE
//  OR OF ANY DERIVATIVE WORK.
//---------------------------------------------------------------------------------------


#import "NSString+XMLExtensions.h"
#import <EDCommon/EDCommon.h>


@implementation NSString (Extensions_XML)

static NSBundle *_bundle = nil;
 
+ (void)setBundle:(NSBundle *)aBundle
{
	_bundle = [aBundle retain];
}

- (NSString *)stringByDecodingEntityEncoding
{
  NSMutableString *decodedString;
  NSString *chunk;
  NSScanner *scanner;
  static NSDictionary *replaceLUT = nil;

  if(replaceLUT == nil)
  {
    NSString *path;
    path = [_bundle pathForResource:@"Entity2String" ofType:@"plist"];
    NSAssert(path != nil, @"Unable to load Entity2String.plist");
    replaceLUT = [[[NSString stringWithData:[NSData dataWithContentsOfFile:path] encoding:NSUnicodeStringEncoding] propertyList] retain];
  }

  decodedString = [[[NSMutableString alloc] init] autorelease];
  scanner = [NSScanner scannerWithString:self];
  [scanner setCharactersToBeSkipped:nil];

  while([scanner isAtEnd] == NO)
  {
    if([scanner scanUpToString:@"&" intoString:&chunk] == YES)
      [decodedString appendString:chunk];

    [scanner scanString:@"&" intoString:NULL]; // skip
    if([scanner scanUpToString:@";" intoString:&chunk])
    {
      NSString *token = [replaceLUT objectForKey:chunk];
      if(token != nil)
      {
        [decodedString appendString:token];
        [scanner scanString:@";" intoString:NULL];
      }
      else
      {
        [decodedString appendString:@"&"];
        [decodedString appendString:chunk];
        [decodedString appendString:@";"];
      }
    }
  }
  return decodedString;
}

@end
