//
//  RDFDocument.m
//  MulleNewz
//
//  Created by znek on Sun Jul 22 2001.
//  $Id: RDFDocument.m,v 1.3 2001/08/01 17:45:48 znek Exp $
//
//  Copyright (c) 2001 by Marcus Mller <znek@mulle-kybernetik.com>.
//  All rights reserved.
//
//  Permission to use, copy, modify and distribute this software and its documentation
//  is hereby granted under the terms of the GNU General Public License, version 2
//  as published by the Free Software Foundation, provided that both the copyright notice
//  and this permission notice appear in all copies of the software, derivative works or
//  modified versions, and any portions thereof, and that both notices appear in supporting
//  documentation, and that credit is given to Marcus Mller in all documents and publicity
//  pertaining to direct or indirect use of this code or its derivatives.
//
//  This is free software; you can redistribute and/or modify it under
//  the terms of the GNU General Public License, version 2 as published by the Free
//  Software Foundation. Further information can be found on the project's web pages
//  at http://www.mulle-kybernetik.com/software/MulleNewz
//
//  THIS IS EXPERIMENTAL SOFTWARE AND IT IS KNOWN TO HAVE BUGS, SOME OF WHICH MAY HAVE
//  SERIOUS CONSEQUENCES. THE COPYRIGHT HOLDER ALLOWS FREE USE OF THIS SOFTWARE IN ITS
//  "AS IS" CONDITION. THE COPYRIGHT HOLDER DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY
//  DAMAGES WHATSOEVER RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE
//  OR OF ANY DERIVATIVE WORK.
//---------------------------------------------------------------------------------------


#import "RDFDocument.h"
#import <EDCommon/EDCommon.h>
#import "RSSChannel.h"
#import "RSSImage.h"
#import "RSSItem.h"
#import "RSSTextInput.h"


@implementation RDFDocument

////////////////////////////////////////////////////
//
//	INIT
//
////////////////////////////////////////////////////


- init
{
	[super init];
	[self takeValue:[[[NSMutableArray allocWithZone:[self zone]] init] autorelease] forAttribute:@"items"];
	return self;
}


////////////////////////////////////////////////////
//
//	OVERRIDING FUN
//
////////////////////////////////////////////////////


- (void)addContainedElement:(MXElement *)someElement
{
  if([someElement isKindOfClass:[RSSChannel class]])
  {
    [self takeValue:someElement forAttribute:@"channel"];
  }
  else if([someElement isKindOfClass:[RSSImage class]])
  {
    [self takeValue:someElement forAttribute:@"image"];
  }
  else if([someElement isKindOfClass:[RSSTextInput class]])
  {
    [self takeValue:someElement forAttribute:@"input"];
  }
  else if([someElement isKindOfClass:[RSSItem class]])
  {
    NSMutableArray *items = [self valueForAttribute:@"items"];
    [items addObject:someElement];
  }
  else
  {
    [super addContainedElement:someElement];
  }
}


////////////////////////////////////////////////////
//
//	ACCESSORS
//
////////////////////////////////////////////////////


- (RSSChannel *)channel
{
  return [self valueForAttribute:@"channel"];
}

- (NSString *)title
{
  return [[self channel] title];
}

- (NSString *)link
{
  return [[self channel] link];
}

- (RSSImage *)image
{
  return [self valueForAttribute:@"image"];
}

- (NSArray *)items
{
  return [self valueForAttribute:@"items"];
}

- (RSSTextInput *)input
{
  return [self valueForAttribute:@"input"];
}

@end
