//---------------------------------------------------------------------------------------
// created as RSSChannel.m by znek on Sun 29-Oct-2000
// $Id: RSSChannel.m,v 1.1.1.1 2001/07/23 06:50:23 znek Exp $
//
//  Copyright (c) 2000 by Marcus Mueller <znek@mulle-kybernetik.com>.
//  All rights reserved.
//
//  Permission to use, copy, modify and distribute this software and its documentation
//  is hereby granted under the terms of the GNU General Public License, version 2
//  as published by the Free Software Foundation, provided that both the copyright notice
//  and this permission notice appear in all copies of the software, derivative works or
//  modified versions, and any portions thereof, and that both notices appear in supporting
//  documentation, and that credit is given to Marcus Mueller in all documents and publicity
//  pertaining to direct or indirect use of this code or its derivatives.
//
//  This is free software; you can redistribute and/or modify it under
//  the terms of the GNU General Public License, version 2 as published by the Free
//  Software Foundation. Further information can be found on the project's web pages
//  at http://www.mulle-kybernetik.com/software/MKPortal
//
//  THIS IS EXPERIMENTAL SOFTWARE AND IT IS KNOWN TO HAVE BUGS, SOME OF WHICH MAY HAVE
//  SERIOUS CONSEQUENCES. THE COPYRIGHT HOLDER ALLOWS FREE USE OF THIS SOFTWARE IN ITS
//  "AS IS" CONDITION. THE COPYRIGHT HOLDER DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY
//  DAMAGES WHATSOEVER RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE
//  OR OF ANY DERIVATIVE WORK.
//---------------------------------------------------------------------------------------


#import "RSSChannel.h"
#import "RSSImage.h"
#import "RSSItem.h"
#import "RSSTextInput.h"


@implementation RSSChannel

////////////////////////////////////////////////////
//
//	OVERRIDING FUN
//
////////////////////////////////////////////////////


- (void)addContainedElement:(MXElement *)someElement
{
  if([someElement isKindOfClass:[RSSImage class]])
  {
    [self takeValue:someElement forAttribute:@"image"];
  }
  else if([someElement isKindOfClass:[RSSTextInput class]])
  {
    [self takeValue:someElement forAttribute:@"input"];
  }
  else if([someElement isKindOfClass:[RSSItem class]])
  {
    NSMutableArray *items = [self valueForAttribute:@"items"];
    if(items == nil)
    {
      items = [[[NSMutableArray allocWithZone:[self zone]] init] autorelease];
      [self takeValue:items forAttribute:@"items"];
    }
    [items addObject:someElement];
  }
  else
  {
    [super addContainedElement:someElement];
  }
}


////////////////////////////////////////////////////
//
//	ACCESSORS
//
////////////////////////////////////////////////////


- (NSString *)title
{
  return [self valueForAttribute:@"title"];
}

- (NSString *)link
{
  return [self valueForAttribute:@"link"];
}

- (NSString *)channelDescription
{
  return [self valueForAttribute:@"description"];
}

- (NSString *)language
{
  return [self valueForAttribute:@"language"];
}

- (RSSImage *)image
{
  return [self valueForAttribute:@"image"];
}

- (NSArray *)items
{
  return [self valueForAttribute:@"items"];
}

- (RSSTextInput *)input
{
  return [self valueForAttribute:@"input"];
}


////////////////////////////////////////////////////
//
//	DEBUGGING
//
////////////////////////////////////////////////////


- (NSString *)description
{
  return [NSString stringWithFormat:@"<%@ 0x%x: title=\"%@\" link=\"%@\" description=\"%@\" image=\"%@\" items=\"%@\">", NSStringFromClass([self class]), self, [self title], [self link], [self channelDescription], [self image], [self items]];
}

@end
