//
//  main.m
//  MulleNewz
//
//  Created by znek on Wed Jul 25 2001.
//  $Id: main.m,v 1.2 2001/07/27 10:24:20 znek Exp $
//
//  Copyright (c) 2001 by Marcus Mller <znek@mulle-kybernetik.com>.
//  All rights reserved.
//
//  Permission to use, copy, modify and distribute this software and its documentation
//  is hereby granted under the terms of the GNU General Public License, version 2
//  as published by the Free Software Foundation, provided that both the copyright notice
//  and this permission notice appear in all copies of the software, derivative works or
//  modified versions, and any portions thereof, and that both notices appear in supporting
//  documentation, and that credit is given to Marcus Mller in all documents and publicity
//  pertaining to direct or indirect use of this code or its derivatives.
//
//  This is free software; you can redistribute and/or modify it under
//  the terms of the GNU General Public License, version 2 as published by the Free
//  Software Foundation. Further information can be found on the project's web pages
//  at http://www.mulle-kybernetik.com/software/MulleNewz
//
//  THIS IS EXPERIMENTAL SOFTWARE AND IT IS KNOWN TO HAVE BUGS, SOME OF WHICH MAY HAVE
//  SERIOUS CONSEQUENCES. THE COPYRIGHT HOLDER ALLOWS FREE USE OF THIS SOFTWARE IN ITS
//  "AS IS" CONDITION. THE COPYRIGHT HOLDER DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY
//  DAMAGES WHATSOEVER RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE
//  OR OF ANY DERIVATIVE WORK.
//---------------------------------------------------------------------------------------


#import <Foundation/Foundation.h>
#import "NSString+XMLExtensions.h"
#import "RSSParser.h"
#import "RSSCache.h"
#import "RSSElements.h"


//
//  In order for this test to work, you need a file called "test.xml"
//  in /tmp directory.
//

int main(int argc, const char *argv[])
{
    NSAutoreleasePool * pool = [[NSAutoreleasePool alloc] init];
    NSBundle *bundle = [[[NSBundle alloc] initWithPath:@"/tmp"] autorelease];
    NSString *rssURLString;
    RSSCache *rssCache;
    id result;

    NSLog(@"Constructed a bundle: %@", bundle);
    
    [RSSCache setBundle:bundle];
    [NSString setBundle:bundle];

    rssCache = [RSSCache sharedCache];

    NSLog(@"Hope the rssCache (%@) is fine ...", rssCache);
    rssURLString = @"file://localhost/tmp/test.xml";
    
    result = [rssCache documentDescriptionForURL:rssURLString];
    [result removeObjectForKey:RSSDocumentKey];
    NSLog(@"result(%@) = %@", rssURLString, result);

    [pool release];
    return 0;
}

