#import <AppKit/AppKit.h>

/*
 File:       ComicsObj.h

 Contains:   Header file for the 3 classes used for the Comics database management:
             CIssue, CTitle, CComics

 Written by: Eric Simenel

 Created:    May 1997

 Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

 Change History (most recent first):

 You may incorporate this sample code into your applications without
 restriction, though the sample code has been provided "AS IS" and the
 responsibility for its operation is 100% yours.  However, what you are
 not permitted to do is to redistribute the source as "DSC Sample Code"
 after having made changes. If you're going to re-distribute the source,
 we require that you make it clear in the source that the code was
 descended from Apple Sample Code, but that you've made changes.
*/

#define debug 0

#define mskMarvel    0x0001
#define mskDC        0x0002
#define mskOther     0x0004
#define mskBrand     0x0007
#define mskNotBrand  0xFFF8

#define mskLong      0x0008
#define mskMini      0x0010
#define mskSeries    0x0018
#define mskNotSeries 0xFFE7

#define mskMain      0x0020
#define mskDual      0x0040
#define mskKind      0x0060
#define mskNotKind   0xFF9F

#define mskLive      0x0080
#define mskDead      0x0100
#define mskState     0x0180
#define mskNotState  0xFE7F

#define mskMiss      0x0001
#define mskPoor      0x0002
#define mskGood      0x0004
#define mskFine      0x0008
#define mskMint      0x0010
#define mskGrade     0x001F
#define mskNotGrade  0xFFE0

#define mskComics    0x0020
#define mskMagazine  0x0040
#define mskNewForm   0x0080
#define mskLuxe      0x0100
#define mskType      0x01E0
#define mskNotType   0xFE1F

#define mskStory     0x0200
#define mskReprint   0x0400
#define mskInfo      0x0800
#define mskCntnt     0x0E00
#define mskNotCntnt  0xF1FF

#define defaultFI   (mskMint | mskComics | mskStory)

@interface CIssue : NSObject
{
    @private
    short issueFlags;
    short issueNumber;
    short editMonth;
    short buyMonth;
}

- (id)init;
- (id)initWithIsh:(short)ish withEdit:(short)edit withBuy:(short)buy withFlag:(short)flag;

- (void)setIssueFlags:(short)value;
- (short)issueFlags;
- (void)setIssueNumber:(short)value;
- (short)issueNumber;
- (void)setEditMonth:(short)value;
- (short)editMonth;
- (void)setBuyMonth:(short)value;
- (short)buyMonth;

- (NSString *)grade;
- (NSString *)ishtype;
- (NSString *)content;

- (id)initWithCoder:(NSCoder *)coder;
- (void)encodeWithCoder:(NSCoder *)coder;

@end

@interface CTitle : NSObject
{
    @private
    short titleFlags;
    NSString *abb;
    NSString *title;
    NSMutableArray *issues;
}

- (id)init;
- (id)initWithAbb:(NSString *)theAbb withTitle:(NSString *)theTitle withFlag:(short)flag;
- (void)dealloc;

- (void)setTitleFlags:(short)value;
- (short)titleFlags;
- (void)setAbb:(NSString *)value;
- (NSString *)abb;
- (void)setTitle:(NSString *)value;
- (NSString *)title;
- (short)nbIssues;
- (void)setIssues:(NSMutableArray *)theArray;
- (NSMutableArray *)issues;

- (NSString *)listIssues;
- (NSString *)brand;
- (NSString *)tstate;
- (NSString *)series;
- (NSString *)kind;

- (id)initWithCoder:(NSCoder *)coder;
- (void)encodeWithCoder:(NSCoder *)coder;

- (short)findIssue:(short)byIshNum;
- (short)addIssue:(CIssue *)theIssue;
- (short)modIssue:(CIssue *)oldIssue withNewIssue:(CIssue *)newIssue;
- (short)deleteIssue:(CIssue *)theIssue;

- (NSComparisonResult)compareAbb:(CTitle *)aTitle;
- (NSComparisonResult)compareTitle:(CTitle *)aTitle;
- (NSComparisonResult)compareChrono:(CTitle *)aTitle;
- (NSComparisonResult)compareMaxIssue:(CTitle *)aTitle;

@end

@interface CComics : NSObject
{
    @private
    short nbIssues;
    short maxIssue;
    short startEditMonth;
    short lastEditMonth;
    short startBuyMonth;
    short lastBuyMonth;
    NSMutableArray *titles;
}

+ (char *)cStrDate:(short)theMonth;
+ (NSString *)nsStrDate:(short)theMonth;
- (id)init;
- (void)dealloc;
- (void)reset;
- (void)setAll;
- (void)setIssue:(CIssue *)theIssue;

- (short)nbIssues;
- (void)modNbIssues:(short)delta;
- (short)maxIssue;
- (short)startEditMonth;
- (short)lastEditMonth;
- (short)startBuyMonth;
- (short)lastBuyMonth;
- (short)nbTitles;
- (NSMutableArray *)titles;
- (void)setTitles:(NSMutableArray *)theArray;

- (void)save:(id)sender;
- (id)initWithCoder:(NSCoder *)coder;
- (void)encodeWithCoder:(NSCoder *)coder;

- (void)sortArray:(NSMutableArray *)theArray withBrand:(short)brand withSeries:(short)series withKind:(short)kind withState:(short)state withSort:(short)sort;

- (short)findTitleByAbb:(NSString *)theAbb;
- (short)findTitleByTitle:(NSString *)theTitle;
- (short)addTitle:(CTitle *)theTitle;
- (short)modTitle:(CTitle *)oldTitle withNewTitle:(CTitle *)newTitle;
- (short)deleteTitle:(CTitle *)theTitle;

@end

// see comment on these globals in ComicsObj.m
extern CComics *comicsBase;
typedef struct {long lens[1001]; long nstrs[1001];} tnumstr;
typedef unsigned char Str3[4];
extern tnumstr gnumstr;
extern Str3 gmonths[12];
extern Str3 gnums[1000];

extern NSString *ComicsDidChangeNotification;