/*
 File:       OutlineController.m

 Contains:   Source code for the Controller of the "Outline" window

 Written by: Eric Simenel

 Created:    October 1997

 Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

 Change History (most recent first):

 You may incorporate this sample code into your applications without
 restriction, though the sample code has been provided "AS IS" and the
 responsibility for its operation is 100% yours.  However, what you are
 not permitted to do is to redistribute the source as "DSC Sample Code"
 after having made changes. If you're going to re-distribute the source,
 we require that you make it clear in the source that the code was
 descended from Apple Sample Code, but that you've made changes.
*/

#import "OutlineController.h"
#import "OutlineNode.h"
#import "ComicsObj.h"

@implementation OutlineController

// The idea is to have an array[brands] of array[series] of array[states] of array[kinds] of array[titles]
// the first 4 levels (brands, series, states, kinds) are initialized with the adequate values
// the last level (titles) is left empty. This array will be filled dynamically in numberOfChildrenOfItem:
// only if need be.
// That way, both memory and speed are preserved.
- (void)_initNodes
{
    NSString *thisName = nil;
    short i, j, k, n;
    nodes = [[NSMutableArray alloc] init];
    for (i=0; i<3; i++)
      {
        OutlineNode *aNode1;
        NSMutableArray *subNodes1;
        switch(i)
          {
            case 0: thisName = [NSString stringWithString:@"All brands"]; break;
            case 1: thisName = [NSString stringWithString:@"Marvel"]; break;
            case 2: thisName = [NSString stringWithString:@"DC & others"]; break;
          }
        aNode1 = [[[OutlineNode alloc] initWithParent:nil withTitle:thisName withIdentification:(0x0000 + i)] autorelease];
        subNodes1 = [[[NSMutableArray alloc] init] autorelease];
        for (j=0; j<3; j++)
          {
            OutlineNode *aNode2;
            NSMutableArray *subNodes2;
            switch(j)
              {
                case 0: thisName = [NSString stringWithString:@"All series"]; break;
                case 1: thisName = [NSString stringWithString:@"Long"]; break;
                case 2: thisName = [NSString stringWithString:@"Mini"]; break;
              }
            aNode2 = [[[OutlineNode alloc] initWithParent:aNode1 withTitle:thisName withIdentification:(0x0100 + j)] autorelease];
            subNodes2 = [[[NSMutableArray alloc] init] autorelease];
            for (k=0; k<3; k++)
              {
                OutlineNode *aNode3;
                NSMutableArray *subNodes3;
                switch(k)
                  {
                    case 0: thisName = [NSString stringWithString:@"All states"]; break;
                    case 1: thisName = [NSString stringWithString:@"Dead"]; break;
                    case 2: thisName = [NSString stringWithString:@"Live"]; break;
                  }
                aNode3 = [[[OutlineNode alloc] initWithParent:aNode2 withTitle:thisName withIdentification:(0x0200 + k)] autorelease];
                subNodes3 = [[[NSMutableArray alloc] init] autorelease];
                for (n=0; n<3; n++)
                  {
                    OutlineNode *aNode4;
                    switch(n)
                      {
                        case 0: thisName = [NSString stringWithString:@"All kinds"]; break;
                        case 1: thisName = [NSString stringWithString:@"Main"]; break;
                        case 2: thisName = [NSString stringWithString:@"Dual"]; break;
                      }
                    aNode4 = [[[OutlineNode alloc] initWithParent:aNode3 withTitle:thisName withIdentification:(0x0300 + n)] autorelease];
                    [subNodes3 addObject:aNode4];
                  }
                [aNode3 setSubNodes:subNodes3];
                [subNodes2 addObject:aNode3];
              }
            [aNode2 setSubNodes:subNodes2];
            [subNodes1 addObject:aNode2];
          }
        [aNode1 setSubNodes:subNodes1];
        [nodes addObject:aNode1];
      }
}

- (id)init
{
    if (self = [super init])
      {
        [self _initNodes];
        // the browser lies in a subproject, so let's get its nib
        if (![NSBundle loadNibNamed:@"Outline" owner:self])
          {
            NSLog(@"Unable to load Outline.nib");
            [nodes release];
            [self release];
            return nil;
          }
      }
    return self;
}

- (void)awakeFromNib
{
    [[outline window] makeKeyAndOrderFront:nil];
}

- (void)dealloc
{
    [nodes release];
}

- (id)outlineView:(NSOutlineView *)outlineView child:(int)index ofItem:(id)item
{
    if (item == nil) return [nodes objectAtIndex:index];
    else return [[item subNodes] objectAtIndex:index];
}

- (BOOL)outlineView:(NSOutlineView *)outlineView isItemExpandable: (id)item
{
    if (item != nil)
      {
        int level;
        if (![item isKindOfClass:[[nodes objectAtIndex:0] class]]) return NO;
        level = [item nodeIdentification] >> 8;
        return (level < 4);
      }
    else return YES;
}

- (int)outlineView:(NSOutlineView *)outlineView numberOfChildrenOfItem:(id)item
{
    if (item == nil) return [nodes count];
    else if ([item subNodes] == nil)
      {
        short brand, series, state, kind;
        NSMutableArray *array = [[[NSMutableArray alloc] init] autorelease];
        kind = [item nodeIdentification] & 0x0FF;
        state = [[item parent] nodeIdentification] & 0x0FF;
        series = [[[item parent] parent] nodeIdentification] & 0x0FF;
        brand = [[[[item parent] parent] parent] nodeIdentification] & 0x0FF;
        [comicsBase sortArray:array withBrand:brand withSeries:series withKind:kind withState:state withSort:0];
        [item setSubNodes:array];
        [item calculateNbIssues];
      }
    return [[item subNodes] count];
}

- (id)outlineView:(NSOutlineView *)outlineView objectValueForTableColumn:(NSTableColumn *)tableColumn byItem:(id)item
{
    NSString *identifier = [tableColumn identifier];
    // item can either be of class CTitle or OutlineNode, but we use polymorphism to
    // call the same methods anyway (title, nbIssues).
    if ([identifier isEqualToString:@"Title"]) return [item title];
    else return [NSString stringWithFormat:@"%ld",[item nbIssues]];
}

@end
