/*
 File:       OutlineNode.h

 Contains:   Header file for the OutlineNode class
             needed by the Controller of the "Outline" window

 Written by: Eric Simenel

 Created:    October 1997

 Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

 Change History (most recent first):

 You may incorporate this sample code into your applications without
 restriction, though the sample code has been provided "AS IS" and the
 responsibility for its operation is 100% yours.  However, what you are
 not permitted to do is to redistribute the source as "DSC Sample Code"
 after having made changes. If you're going to re-distribute the source,
 we require that you make it clear in the source that the code was
 descended from Apple Sample Code, but that you've made changes.
*/

#import <AppKit/AppKit.h>

@interface OutlineNode : NSObject
{
    OutlineNode *parent;
    NSString *title;
    NSMutableArray *subNodes;
    short nodeIdentification;
    short nbIssues;
}

- (id)initWithParent:(OutlineNode *)theParent withTitle:(NSString *)theTitle withIdentification:(short)ident;
- (id)init;
- (void)dealloc;
- (NSString *)title;
- (OutlineNode *)parent;
- (NSMutableArray *)subNodes;
- (void)setSubNodes:(NSMutableArray *)theArray;
- (short)nodeIdentification;
- (short)nbIssues;
- (void)calculateNbIssues;

@end
