/*
 File:       OutlineNode.m

 Contains:   Source code for the OutlineNode class
             needed by the Controller of the "Outline" window

 Written by: Eric Simenel

 Created:    October 1997

 Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

 Change History (most recent first):

 You may incorporate this sample code into your applications without
 restriction, though the sample code has been provided "AS IS" and the
 responsibility for its operation is 100% yours.  However, what you are
 not permitted to do is to redistribute the source as "DSC Sample Code"
 after having made changes. If you're going to re-distribute the source,
 we require that you make it clear in the source that the code was
 descended from Apple Sample Code, but that you've made changes.
*/

#import "OutlineNode.h"
#import "ComicsObj.h"

@implementation OutlineNode

- (id)initWithParent:(OutlineNode *)theParent withTitle:(NSString *)theTitle withIdentification:(short)ident
{
    if (self = [super init])
      {
        parent = theParent;
        title = [theTitle retain];
        nodeIdentification = ident;
        nbIssues = 0;
        subNodes = nil;
      }
    return self;
}

- (id)init
{
    return [self initWithParent:nil withTitle:@"" withIdentification:0];
}

- (void)dealloc
{
    [title release];
    if (subNodes != nil) [subNodes release];
}

- (NSString *)title
{
    return title;
}

- (OutlineNode *)parent
{
    return parent;
}

- (NSMutableArray *)subNodes
{
    return subNodes;
}

- (void)setSubNodes:(NSMutableArray *)theArray
{
    [theArray retain];
    if (subNodes != nil) [subNodes release];
    subNodes = theArray;
}

- (short)nodeIdentification
{
    return nodeIdentification;
}

- (short)nbIssues
{
    return nbIssues;
}

- (void)calculateNbIssues
{
    if ((nodeIdentification & 0xFF00) == 0x0300)
      {
        if (subNodes != nil)
          {
            short i;
            nbIssues = 0;
            for (i=0; i<[subNodes count]; i++) nbIssues += [[subNodes objectAtIndex:i] nbIssues];
          }
        else nbIssues = 0;
      }
   else
     {
       short i;
       nbIssues = [[subNodes objectAtIndex:0] nbIssues];
       if (nbIssues == 0)
           for (i=1; i<[subNodes count]; i++) nbIssues += [[subNodes objectAtIndex:i] nbIssues];
     }
    if (parent != nil) [parent calculateNbIssues];
}

@end
