/*
 File:       TitleLongevityView.m

 Contains:   Source code for the custom View of the "Title Longevity/Edited" window

 Written by: Eric Simenel

 Created:    May 1997

 Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

 Change History (most recent first):

 You may incorporate this sample code into your applications without
 restriction, though the sample code has been provided "AS IS" and the
 responsibility for its operation is 100% yours.  However, what you are
 not permitted to do is to redistribute the source as "DSC Sample Code"
 after having made changes. If you're going to re-distribute the source,
 we require that you make it clear in the source that the code was
 descended from Apple Sample Code, but that you've made changes.
*/

#import "TitleLongevityView.h"
#import "ComicsObj.h"

@implementation TitleLongevityView

- (id)initWithFrame:(NSRect)rect
{
    if (self = [super initWithFrame:rect])
      {
        font = [[NSFont fontWithName:@"Ohlfs" size:9] retain];
        dictionary = [[NSMutableDictionary dictionary] retain];
        [dictionary setObject:font forKey:NSFontAttributeName];
        // I have a lttle less than 1500 titles currently, hence the following capacity...
        array = [[NSMutableArray alloc] initWithCapacity:1500];
        nbSelTitles = 0;
      }
    return self;
}
- (void)dealloc
{
    [array release];
    [font release];
    [dictionary release];
    [super dealloc];
}

#define orx 20
#define ory 20

- (void)drawRect:(NSRect)rect
{
    NSString *theString;
    short i, j, startEditMonth, lastEditMonth, tlarr[600];

    // get the right array of titles
    [comicsBase sortArray:array withBrand:brand withSeries:series withKind:1 withState:0 withSort:0];
    nbSelTitles = [array count];
    startEditMonth = [comicsBase startEditMonth];
    lastEditMonth = [comicsBase lastEditMonth];

    // clear and then fill the local array to be graphed
    for(i=0; i<(lastEditMonth-startEditMonth); i++) tlarr[i] = 0;
    for(i=0; i<nbSelTitles; i++)
      {
        CTitle *thisTitle = [array objectAtIndex:i];
        NSMutableArray *theseIssues = [thisTitle issues];
        // if edited then add 1 if there is an issue for this particular edit month
        if (!editOrLong) for(j=0; j < [thisTitle nbIssues]; j++) tlarr[[[theseIssues objectAtIndex:j] editMonth] - startEditMonth] += 1;
        // else add 1 for all months between the first published issue to the latest
        else for(j=[[theseIssues objectAtIndex:0] editMonth]; j <= [[theseIssues lastObject] editMonth]; j++) tlarr[j-startEditMonth] += 1;
      }

    // draw the axes
    PSsetrgbcolor(0, 0, 0);
    PSmoveto(orx, ory-3); PSlineto(orx, 700); PSstroke();
    PSmoveto(orx-3, ory); PSlineto(700, ory); PSstroke();
    // put the labels on vertical axis
    for(i=10; i<=130; i+=10)
      {
        PSmoveto(orx-3, ory+i*5); PSlineto(700, ory+i*5); PSstroke();
        theString = [NSString stringWithCString:gnums[i]];
        [theString drawAtPoint:NSMakePoint(orx-20, ory-12+i*5) withAttributes:dictionary];
      }
    [[NSString stringWithString:@"Number of Issues"] drawAtPoint:NSMakePoint(orx+10, ory+655)
                                                  withAttributes:dictionary];
    // put the labels on horizontal axis
    for(i=0; i<(lastEditMonth-startEditMonth+13); i++) if (((i + startEditMonth-1) % 12) == 0)
      {
        j = (i + startEditMonth-1) / 12;
        PSmoveto(orx+i, ory); PSlineto(orx+i, ory-3-((j % 2)?7:0));PSstroke();
        theString = [NSString stringWithCString:gnums[j]];
        [theString drawAtPoint:NSMakePoint(orx+i-9, ory-21-((j % 2)?7:0)) withAttributes:dictionary];
      }
    [[NSString stringWithString:@"Years"] drawAtPoint:NSMakePoint(orx+lastEditMonth-startEditMonth+40, ory-21)
                                       withAttributes:dictionary];
    // draw the graph in blue
    PSsetrgbcolor(0, 0, 32767);
    for(i=0; i<(lastEditMonth-startEditMonth); i++)
      {
        PSmoveto(orx+i, ory);
        PSlineto(orx+i, ory+tlarr[i]*5);
        PSstroke();
      }
}

- (short)nbSelTitles { return nbSelTitles; }
- (void)setBrand:(short)value { brand = value; }
- (void)setSeries:(short)value { series = value; }
- (void)setEditOrLong:(short)value { editOrLong = value; }


@end
