/*
 File:       WindowController.m

 Contains:   Source code for the Window Controller of the Floating Palette application

 Written by: Eric Simenel

 Created:    November 1997

 Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

 Change History (most recent first):

 You may incorporate this sample code into your applications without
 restriction, though the sample code has been provided "AS IS" and the
 responsibility for its operation is 100% yours.  However, what you are
 not permitted to do is to redistribute the source as "DSC Sample Code"
 after having made changes. If you're going to re-distribute the source,
 we require that you make it clear in the source that the code was
 descended from Apple Sample Code, but that you've made changes.
*/

#import "WindowController.h"

@implementation WindowController

- (id)init
{
    if (self = [super init])
      {
        // the window lies in a subproject, so let's get its nib
        if (![NSBundle loadNibNamed:@"Window" owner:self])
          {
            NSLog(@"Unable to load Window.nib");
            [self release];
            return nil;
          }
      }
    return self;
}

- (void)awakeFromNib
{
    [theWindow makeKeyAndOrderFront:nil];
}

@end
