#import "Document.h"
#import "SmallImageView.h"

@implementation Document

static int mwinnum=1;

- (id)initWithDocument:(NSString *)aPath
{
    NSRect rct;
    NSFileManager *fileManager;

    if (![NSBundle loadNibNamed:@"Document" owner:self])
            {
                    NSLog(@"Failed to Load Document.nib");
                    [self release];
                    return nil;
            }



    [docWindow setTitleWithRepresentedFilename:aPath];
    //Window򳫤ˤϰ֤򾯤餹
    rct=[docWindow frame];
    rct.origin.x+=mwinnum*24.0;
    rct.origin.y-=mwinnum*24.0;
    //NSLog(@"size=%f,%f",rct.size.width,rct.size.height);
    [docWindow setFrame:rct display:NO];
    mwinnum++;



    documentPath=[aPath copy];

    fileManager=[NSFileManager defaultManager];

    pictureListFile=[[aPath stringByAppendingPathComponent:@"index"] copy];
    //index file ؤpath

    if ([fileManager fileExistsAtPath:pictureListFile] == YES) {
        //index file¸ߤ뤫?
        pictureList = [[NSMutableArray alloc] initWithContentsOfFile:pictureListFile];
        if (pictureList) {

            if ([pictureList count] > 0) {
                [runButton setEnabled:YES];
            }

        } else {
            NSRunAlertPanel(@"LightPoint", NSLocalizedString(@"Couldn't open file %@",@""), nil, nil, nil, pictureListFile);
            return nil;
        }

    } else {
        //ɥ
        //WindowUNTITLED˿Ĥ
        pictureList=[[NSMutableArray alloc] init];
    }


    [self refreshThumbnailView];
    [self setInfoToCellWithImage];

    selectedPict=0;
    //[thumbnailMatrix selectCellWithTag:selectedPict];

    //ɥκ硦Ǿ
    [docWindow setMaxSize:NSMakeSize(451,1200)];
    [docWindow setMinSize:NSMakeSize(451,448)];

    //Windowɽ
    [docWindow makeKeyAndOrderFront:self];
    [docWindow makeMainWindow];

    return self;

}

- (void)refreshThumbnailView
{
    NSRect rect;
    int row;

    row=[pictureList count]/5 + 1;  //Ĥοϼ̿/ο

    remainCells=row*5-[pictureList count];//ֲΤޤޤäƤʤcellο

    [slideScroll setHasHorizontalScroller:NO];
    [slideScroll setHasVerticalScroller:YES];
    rect = [slideScroll frame];

    thumbnailMatrix = [[NSMatrix alloc] initWithFrame: rect
                                                 mode: NSRadioModeMatrix
                                            cellClass:[ThumbnailCell class]
                                         numberOfRows: row numberOfColumns: 5];

    [thumbnailMatrix setAllowsEmptySelection:YES];
    [thumbnailMatrix setCellSize: NSMakeSize(80,80)];
    [thumbnailMatrix sizeToCells];
    [thumbnailMatrix setTarget: self];
    [thumbnailMatrix setAction: @selector(clickAct:)];
    [thumbnailMatrix setDoubleAction: @selector(doubleClickAct:)];
    [thumbnailMatrix setDelegate: self];


    [docWindow setDelegate: self];

    [slideScroll setLineScroll: 70];
    [slideScroll setBorderType:NSLineBorder];
    [thumbnailMatrix setBackgroundColor: [NSColor darkGrayColor]];
    [slideScroll setDocumentView: thumbnailMatrix];


    [thumbnailMatrix selectCellAtRow:-1 column:-1];
    //NSLog(@"init selected column=%d",[thumbnailMatrix selectedColumn]);
    //NSLog(@"init selected Row=%d",[thumbnailMatrix selectedRow]);

    //[docWindow setAutodisplay:NO];
    //[docWindow setMaxSize:NSMakeSize(475,1024)];
    //[docWindow makeKeyAndOrderFront:self];
}

- (void)setInfoToCellWithImage
{
    int i,j,num,maxNumber;
    ThumbnailCell *aThumbnailCell;
    unsigned int numberOfPics;

    numberOfPics=[pictureList count];
    maxNumber=(numberOfPics/5+1)*5;


    for (num=0;num<maxNumber+1;num++) {
        //NSLog(@"setInfo");
        j=num%5;i=num/5;
        aThumbnailCell = [thumbnailMatrix cellAtRow:i column:j];

        if (num<numberOfPics) {
            [aThumbnailCell setInfo:num image:[documentPath stringByAppendingPathComponent:[pictureList objectAtIndex:num]]];
            //[thumbnailMatrix display];
        } else {
            [aThumbnailCell setInfo:-1 image:nil];
        }

    }
}

- (void)makeFront
{
    [docWindow makeKeyAndOrderFront:self];
    [docWindow makeMainWindow];
}

- (void)checkRemainCellsAtRow:(int)aRow
{
    int j;
    ThumbnailCell *aThumbnailCell;


    if (remainCells==0) {

        [thumbnailMatrix addRow];

        for(j=0;j<5;j++) {
            aThumbnailCell = [thumbnailMatrix cellAtRow:aRow column:j];
            [aThumbnailCell setInfo:-1 image:nil];
        }

        [thumbnailMatrix sizeToCells];

        remainCells=5;

        //NSLog(@"column %d  row %d",[thumbnailMatrix numberOfColumns],[thumbnailMatrix numberOfRows]);

        }

}


- (void)addNewData:(id)sender
{
    NSString *originalFile;
    NSString *newFile;
    ThumbnailCell *aThumbnailCell;
    int i,j;
    NSCalendarDate *now = [NSCalendarDate calendarDate];

    NSFileManager *fileManager;

    //NSLog(@"count=%d",listCount);

    originalFile=[[smallImageView currentFilename] copy];
    //NSLog(@"original file = %@",originalFile);


    newFile=[documentPath stringByAppendingPathComponent:[[now
                 descriptionWithCalendarFormat:@"%y%m%d%H%M%S%F"] stringByAppendingPathExtension:[originalFile pathExtension]]];

    //NSLog(@"new file = %@",newFile);

    fileManager=[NSFileManager defaultManager];
    [fileManager copyPath:originalFile toPath:newFile handler:nil];
    //ɥå줿եdocument path˥ԡ롣

    [pictureList addObject:[[newFile lastPathComponent] copy]];
    selectedPict = [pictureList count] - 1;
    //򤵤Ƥ륹饤


    j=selectedPict%5;i=selectedPict/5;

    [self checkRemainCellsAtRow:i];
    remainCells -= 1;
    aThumbnailCell = [thumbnailMatrix cellAtRow:i column:j];
    [aThumbnailCell setInfo:selectedPict image:newFile];
    //[thumbnailMatrix display];
    //NSLog(@"selectedPict=%d",selectedPict);
    [thumbnailMatrix selectCellWithTag:selectedPict]; //ɲä򤹤
    //NSLog(@"selected cell tag=%d",[[thumbnailMatrix selectedCell] tag]);
    //NSLog(@"selected Column tag=%d",[thumbnailMatrix selectedColumn]);

    [addButton setEnabled:NO];
    [insertButton setEnabled:NO];
    [replaceButton setEnabled:NO];
    [deleteButton setEnabled:YES];
    [runButton setEnabled:YES];

    [docWindow setDocumentEdited:YES];

}

- (void)deleteData:(id)sender
{
    NSFileManager *fileManager;
    NSString *backupFile;
    int count;

    //deleteȤϡpictureListremove뤬եϥե̾Ƭ#Ĥ
    //¸ƤsaveȤˤʤäƤ顢#ΤĤեä

    fileManager=[NSFileManager defaultManager];

    backupFile=[documentPath stringByAppendingPathComponent:[[NSString stringWithString:@"#"] stringByAppendingString:[pictureList objectAtIndex:selectedPict]]];

    //NSLog(@"backup file = %@",backupFile);

    [fileManager movePath:[documentPath stringByAppendingPathComponent:[pictureList objectAtIndex:selectedPict]] toPath:backupFile handler:nil];


    [pictureList removeObjectAtIndex:selectedPict];

    [thumbnailMatrix setNeedsDisplay:NO];
    [self refreshThumbnailView];
    [self setInfoToCellWithImage];
    [thumbnailMatrix setNeedsDisplay:YES];

    count=[pictureList count];

    if (selectedPict>count-1) {
        selectedPict -= 1;
    }


    [addButton setEnabled:NO];
    [insertButton setEnabled:NO];
    [replaceButton setEnabled:NO];

    if (count==0) {
        [deleteButton setEnabled:NO];
        [runButton setEnabled:NO];
        [smallImageView displaySmallImage:nil];

    } else {
        [deleteButton setEnabled:YES];

        [thumbnailMatrix selectCellWithTag:selectedPict];
        [smallImageView displaySmallImage:[[thumbnailMatrix selectedCell] filename]];
    }

    [docWindow setDocumentEdited:YES];

}

- (void)insertData:(id)sender
{
    NSString *originalFile;
    NSString *newFile;
    //ThumbnailCell *aThumbnailCell;
    //int i,j;
    NSCalendarDate *now = [NSCalendarDate calendarDate];

    NSFileManager *fileManager;

    originalFile=[[smallImageView currentFilename] copy];

    newFile=[documentPath stringByAppendingPathComponent:[[now
                 descriptionWithCalendarFormat:@"%y%m%d%H%M%S%F"] stringByAppendingPathExtension:[originalFile pathExtension]]];

    fileManager=[NSFileManager defaultManager];
    [fileManager copyPath:originalFile toPath:newFile handler:nil];
    //ɥå줿եdocument path˥ԡ롣

    [pictureList insertObject:[[newFile lastPathComponent] copy] atIndex:selectedPict];

    [thumbnailMatrix setNeedsDisplay:NO];
    [self refreshThumbnailView];
    [self setInfoToCellWithImage];
    [thumbnailMatrix setNeedsDisplay:YES];


    [addButton setEnabled:NO];
    [insertButton setEnabled:NO];
    [replaceButton setEnabled:NO];
    [deleteButton setEnabled:YES];

    [thumbnailMatrix selectCellWithTag:selectedPict];

    [docWindow setDocumentEdited:YES];


}

- (void)replaceData:(id)sender
{
    NSFileManager *fileManager;
    NSString *originalFile;
    NSString *newFile;
    NSString *backupFile;
    NSCalendarDate *now = [NSCalendarDate calendarDate];
    ThumbnailCell *aThumbnailCell;

    fileManager=[NSFileManager defaultManager];

    //ޤեХåå("#"Ĥ)
    backupFile=[documentPath stringByAppendingPathComponent:[[NSString stringWithString:@"#"] stringByAppendingString:[pictureList objectAtIndex:selectedPict]]];

    [fileManager movePath:[documentPath stringByAppendingPathComponent:[pictureList objectAtIndex:selectedPict]] toPath:backupFile handler:nil];



    //񤭤եdocumentPath˥ԡ
    originalFile=[[smallImageView currentFilename] copy];
    newFile=[documentPath stringByAppendingPathComponent:[[now
                 descriptionWithCalendarFormat:@"%y%m%d%H%M%S%F"] stringByAppendingPathExtension:[originalFile pathExtension]]];
    [fileManager copyPath:originalFile toPath:newFile handler:nil];



    [pictureList replaceObjectAtIndex:selectedPict withObject:[[newFile lastPathComponent] copy]];


    aThumbnailCell=[thumbnailMatrix selectedCell];
    [aThumbnailCell setInfo:selectedPict image:newFile];


    //[self refreshThumbnailView];
    //[self setInfoToCellWithImage];


    [addButton setEnabled:NO];
    [insertButton setEnabled:NO];
    [replaceButton setEnabled:NO];
    [deleteButton setEnabled:YES];

    [thumbnailMatrix selectCellWithTag:selectedPict];

    [docWindow setDocumentEdited:YES];


}

- (void)runSlide:(id)sender
{
    id mainScreen=[NSScreen mainScreen];
    NSRect screenRect=[mainScreen frame];

    aSlideView=[[SlideView alloc] initWithFrame:screenRect];
    [aSlideView setDocumentPath:documentPath];
    [aSlideView setPictureList:pictureList];

    newWindow=[[SlideWindow alloc] initWithContentRect:screenRect styleMask:0 backing:NSBackingStoreBuffered defer:YES];

    [newWindow setReleasedWhenClosed:YES];
    [newWindow setLevel:NSMainMenuWindowLevel+1];
    [newWindow setContentView:aSlideView];
    [newWindow makeFirstResponder:aSlideView];

    [newWindow makeKeyAndOrderFront:self];
}


- (void)clickAct:(id)sender
{

    id	cell;
    cell=[sender selectedCell];

    selectedPict=[cell tag];
    //NSLog(@"selectedPict=%d",selectedPict);

    [smallImageView displaySmallImage:[cell filename]];

    [addButton setEnabled:NO];
    [insertButton setEnabled:NO];
    [replaceButton setEnabled:NO];
    [deleteButton setEnabled:YES];
}



- (void)doubleClickAct:(id)sender
{
    [[NSWorkspace sharedWorkspace] openFile:[[sender selectedCell] filename]];
    //NSLog(@"double click");

}


- (BOOL)saveDocument
{
    NSString *fn;
    NSFileManager *fileManager;
    NSArray *dirContents;
    unsigned int contensNum;
    int i;

    fn = [documentPath stringByAppendingPathComponent:@"index"];

    if (![pictureList writeToFile:fn atomically:YES]) {
        NSRunAlertPanel(@"LightPoint", NSLocalizedString(@"Couldn't save file %@",@""), nil, nil, nil, fn);

        return NO;
    }


    fileManager=[NSFileManager defaultManager];

    dirContents=[fileManager directoryContentsAtPath:documentPath];
    contensNum=[dirContents count];

    //directory#ǻϤޤե̾Υե뤬ä顢
    for (i=0;i<contensNum;i++) {
        //NSLog(@"string=%@",[[dirContents objectAtIndex:i] substringToIndex:1]);
        if ([[[dirContents objectAtIndex:i] substringToIndex:1] isEqualToString:@"#"] == YES) {
            [fileManager removeFileAtPath:[documentPath stringByAppendingPathComponent:[dirContents objectAtIndex:i]] handler:nil];
           
        }
    }


    [docWindow setDocumentEdited:NO];

    return YES;
}


- (void)revertToSaved
{
    int fileCount;

    //ޤƤȤ᤹
    [self restoreFile];

    //˥ꥹȼΤ̤᤹
    pictureList = [[NSMutableArray alloc] initWithContentsOfFile:[documentPath stringByAppendingPathComponent:@"index"]];


    [thumbnailMatrix setNeedsDisplay:NO];
    [self refreshThumbnailView];
    [self setInfoToCellWithImage];
    [thumbnailMatrix setNeedsDisplay:YES];


    fileCount=[pictureList count]-1;
    if (selectedPict > fileCount) {
        selectedPict=fileCount;
    }
    [thumbnailMatrix selectCellWithTag:selectedPict];
    [smallImageView displaySmallImage:[[thumbnailMatrix selectedCell] filename]];


    [docWindow setDocumentEdited:NO];

}

- (void)restoreFile
{
    int i;
    int fileCount;

    NSFileManager *fileManager;
    NSString *originalListFile;
    NSMutableArray *currentList;
    NSMutableArray *originalList;

    fileManager=[NSFileManager defaultManager];

    originalListFile = [documentPath stringByAppendingPathComponent:@"index"];

    currentList=[NSMutableArray arrayWithArray:[pictureList copy]];//ߤΥꥹ
    originalList=[[NSMutableArray alloc] initWithContentsOfFile:originalListFile];//ꥸʥ
    [currentList removeObjectsInArray:originalList];
    //ߤΥꥹȤˤʤΥꥹȤĤ롣

    fileCount=[currentList count];
    if (fileCount > 0) {
        for (i=0;i<fileCount;i++) {
            //NSLog(@"removing file %@",[documentPath stringByAppendingPathComponent:[currentList objectAtIndex:i]]);
            [fileManager removeFileAtPath:[documentPath stringByAppendingPathComponent:[currentList objectAtIndex:i]] handler:nil];
        }
    }


    currentList=[NSMutableArray arrayWithArray:[pictureList copy]];
    [originalList removeObjectsInArray:currentList];
    //ꥸʥΥꥹȤˤʤΥꥹȤĤ롣褵롣

    fileCount=[originalList count];
    if (fileCount > 0) {
        for (i=0;i<fileCount;i++) {
            //NSLog(@"move file %@ to %@",[documentPath stringByAppendingPathComponent:[[NSString stringWithString:@"#"] stringByAppendingString:[originalList objectAtIndex:i]]],[documentPath stringByAppendingPathComponent:[originalList objectAtIndex:i]]);

            [fileManager movePath:[documentPath stringByAppendingPathComponent:[[NSString stringWithString:@"#"] stringByAppendingString:[originalList objectAtIndex:i]]]
                           toPath:[documentPath stringByAppendingPathComponent:[originalList objectAtIndex:i]]
                          handler:nil];
        }
    }



}

- (void)saveAs:(NSString *)aPath
{
    NSString *fn;
    NSFileManager *fileManager;
    unsigned int picturesNum;
    int i;

    fn = [aPath stringByAppendingPathComponent:@"index"];

    if (![pictureList writeToFile:fn atomically:YES]) {
        NSRunAlertPanel(@"LightPoint", NSLocalizedString(@"Couldn't save file %@",@""), nil, nil, nil, fn);

        return;
    }


    fileManager=[NSFileManager defaultManager];

    picturesNum=[pictureList count];

    for (i=0;i<picturesNum;i++) {
        [fileManager copyPath:[documentPath stringByAppendingPathComponent:[pictureList objectAtIndex:i]] toPath:[aPath stringByAppendingPathComponent:[pictureList objectAtIndex:i]] handler:nil];
    }

    //ȤΥե򥻡ֻ᤹
    [self restoreFile];

    //ɥΥȥ򹹿
    [docWindow setTitleWithRepresentedFilename:aPath];
    //cellξ򹹿
    [self setInfoToCellWithImage];

    //ѥ򹹿
    documentPath=[aPath copy];


    [docWindow setDocumentEdited:NO];

    return;


}



- (BOOL)windowShouldClose:(id)sender
{
    int result;
    if (![docWindow isDocumentEdited]) {
        return YES;
    }

    result = NSRunAlertPanel(NSLocalizedString(@"Close",@""),
                             NSLocalizedString(@"Edited",@""),
                             NSLocalizedString(@"Save",@""),
                             NSLocalizedString(@"Don't Save",@""),
                             NSLocalizedString(@"Cancel",@""));

    switch(result) {
        case NSAlertDefaultReturn: {
            [self saveDocument];
            return YES;
        }
        case NSAlertAlternateReturn: {
            [self revertToSaved];
            return YES;
        }
        case NSAlertOtherReturn: {
            return NO;
        }
    }
    return NO;
}


@end
