/* ThumbnailCell.m created by nakamura on Wed 07-Oct-1998 */

#import "ThumbnailCell.h"

@implementation ThumbnailCell
- init
{
        [super init];
        //info = nil;
        [self setImagePosition: NSImageAbove];
        [self setBezeled:YES];
        [self setButtonType:NSOnOffButton];
        [self setAlignment:NSCenterTextAlignment];
        [self setShowsFirstResponder:NO];
        [self setTitle:@""];
        return self;
}

- (void)setInfo:(int)num image:(NSString *)imageFileName
{
    NSImage *thumbnailImage;
    id thumbnailImageRep;

    if (num==-1) {
        [self setTransparent:YES];
        [self setEnabled:NO];
        [self setTitle:@""];
        [self setImage:nil];
        [self setTag:num];
    } else {
        [self setTransparent:NO];
        [self setEnabled:YES];
        if (!imageFileName) {
            [self setTitle:[NSString localizedStringWithFormat:@"%d",num+1]];
            [self setImage:nil];
        } else {
            myFileName=[imageFileName copy];  //ե͡¸
            //NSLog(@"myFileName=%@",myFileName);
            thumbnailImageRep=[NSImageRep  imageRepWithContentsOfFile:imageFileName];
            thumbnailImage=[[NSImage allocWithZone:[self zone]] initWithSize:NSMakeSize(80,60)];
            [thumbnailImage setScalesWhenResized:YES];
            [thumbnailImage addRepresentation:thumbnailImageRep];

            [self setImage:thumbnailImage];
            [self setTitle:[NSString localizedStringWithFormat:@"%d",num+1]];
        }

        [self setTag:num];
        //NSLog(@"my tag=%d",[self tag]);
    }

}


- (NSString *)filename
{
    return myFileName;
}

@end
