#ifndef CFG_DEFS_H
#define CFG_DEFS_H 1

static CONST struct {
	CONST char *name;
	CONST char *value;
} config_cache[] = {
	{ "SYSTEM_MAIL", "/usr/sbin/sendmail" },
	{ "alt_char_set", "no" },
	{ "baddef_remove", "no" },
	{ "bool_defs", "yes" },
	{ "c_const", "yes" },
	{ "color_curses", "no" },
	{ "dcl_errno", "yes" },
	{ "dcl_sys_errlist", "yes" },
	{ "dcl_sys_nerr", "yes" },
	{ "fancy_curses", "no" },
	{ "fionbio", "ioctl" },
	{ "func_cbreak", "yes" },
	{ "func_cuserid", "no" },
	{ "func_decl_getgrgid", "yes" },
	{ "func_decl_getgrnam", "yes" },
	{ "func_decl_strstr", "yes" },
	{ "func_define_key", "no" },
	{ "func_getcwd", "yes" },
	{ "func_getgroups", "yes" },
	{ "func_gethostbyname", "yes" },
	{ "func_gethostname", "yes" },
	{ "func_initscr", "yes" },
	{ "func_keypad", "no" },
	{ "func_lstat", "yes" },
	{ "func_mktime", "yes" },
	{ "func_putenv", "yes" },
	{ "func_readdir", "yes" },
	{ "func_socket", "yes" },
	{ "func_strcasecmp", "yes" },
	{ "func_strerror", "yes" },
	{ "func_strstr", "yes" },
	{ "func_use_default_colors", "no" },
	{ "func_vfork_works", "yes" },
	{ "func_waitpid", "yes" },
	{ "func_wborder", "no" },
	{ "have_errno", "yes" },
	{ "have_lib_ncurses", "yes" },
	{ "have_sys_errlist", "yes" },
	{ "have_sys_nerr", "yes" },
	{ "have_ttytype", "yes" },
	{ "have_utmp", "yes" },
	{ "header_dirent_dirent_h", "yes" },
	{ "header_fcntl_h", "yes" },
	{ "header_limits_h", "yes" },
	{ "header_stdc", "yes" },
	{ "header_stdlib_h", "yes" },
	{ "header_string_h", "yes" },
	{ "header_sys_fcntl_h", "yes" },
	{ "header_sys_filio_h", "yes" },
	{ "header_sys_ioctl_h", "yes" },
	{ "header_sys_param_h", "yes" },
	{ "header_sys_time_h", "yes" },
	{ "header_sys_wait_h", "yes" },
	{ "header_termio_h", "no" },
	{ "header_termios_h", "yes" },
	{ "header_time", "yes" },
	{ "header_unistd_h", "yes" },
	{ "header_vfork_h", "no" },
	{ "lib_dir_opendir", "no" },
	{ "lib_gpm_Gpm_Open", "no" },
	{ "lib_inet", "no" },
	{ "locale", "yes" },
	{ "ncurses_broken", "no" },
	{ "ncurses_header", "/usr/local/include/curses.h" },
	{ "ncurses_version", "5.0.990318" },
	{ "netlibs", "" },
	{ "ngroups", "yes" },
	{ "path_CHMOD", "/bin/chmod" },
	{ "path_COMPRESS", "/usr/bin/compress" },
	{ "path_COPY", "/bin/cp" },
	{ "path_GZIP", "/usr/bin/gzip" },
	{ "path_MKDIR", "/bin/mkdir" },
	{ "path_MV", "/bin/mv" },
	{ "path_RM", "/bin/rm" },
	{ "path_TAR", "/usr/bin/tar" },
	{ "path_TOUCH", "/usr/bin/touch" },
	{ "path_UNCOMPRESS", "/usr/bin/gunzip" },
	{ "path_UNZIP", "/usr/bin/unzip" },
	{ "path_UUDECODE", "/usr/bin/uudecode" },
	{ "path_ZCAT", "/usr/bin/zcat" },
	{ "path_ZIP", "/usr/bin/zip" },
	{ "path_install", "/usr/bin/install -c" },
	{ "prog_CC", "cc" },
	{ "prog_CPP", "cc -E -traditional-cpp" },
	{ "prog_RANLIB", "ranlib" },
	{ "prog_cc_cross", "no" },
	{ "prog_cc_g", "yes" },
	{ "prog_cc_works", "yes" },
	{ "prog_gcc", "yes" },
	{ "prog_make_make_set", "yes" },
	{ "screen", "ncurses" },
	{ "sizechange", "yes" },
	{ "system_mail_flags", "-t -oi" },
	{ "termio_and_curses", "no" },
	{ "termio_and_termios", "yes" },
	{ "type_getgroups", "gid_t" },
	{ "type_mode_t", "yes" },
	{ "type_pid_t", "yes" },
	{ "type_uid_t", "yes" },
	{ "type_unionwait", "no" },
	{ "use_libsocks", "no" },
	{ "use_libsocks5", "no" },
};

static CONST struct {
	CONST char *name;
	CONST char *value;
} config_defines[] = {
	{ "CHMOD_PATH", "/bin/chmod" },
	{ "COMPRESS_PATH", "/usr/bin/compress" },
	{ "COPY_PATH", "/bin/cp" },
	{ "DIRED_SUPPORT", "1" },
	{ "DISP_PARTIAL", "1" },
	{ "DONT_TRACK_INTERNAL_LINKS", "1" },
	{ "FANCY_CURSES", "1" },
	{ "GETGROUPS_T", "gid_t" },
	{ "GZIP_PATH", "/usr/bin/gzip" },
	{ "HAVE_CBREAK", "1" },
	{ "HAVE_DIRENT_H", "1" },
	{ "HAVE_FCNTL_H", "1" },
	{ "HAVE_GETCWD", "1" },
	{ "HAVE_GETGROUPS", "1" },
	{ "HAVE_LIMITS_H", "1" },
	{ "HAVE_LSTAT", "1" },
	{ "HAVE_PUTENV", "1" },
	{ "HAVE_READDIR", "1" },
	{ "HAVE_SIZECHANGE", "1" },
	{ "HAVE_STDLIB_H", "1" },
	{ "HAVE_STRERROR", "1" },
	{ "HAVE_STRING_H", "1" },
	{ "HAVE_SYS_FCNTL_H", "1" },
	{ "HAVE_SYS_FILIO_H", "1" },
	{ "HAVE_SYS_IOCTL_H", "1" },
	{ "HAVE_SYS_WAIT_H", "1" },
	{ "HAVE_TERMIOS_H", "1" },
	{ "HAVE_TTYTYPE", "1" },
	{ "HAVE_UNISTD_H", "1" },
	{ "HAVE_UTMP", "1" },
	{ "HAVE_WAITPID", "1" },
	{ "INSTALL_PATH", "/usr/bin/install -c" },
	{ "LOCALE", "1" },
	{ "LONG_LIST", "1" },
	{ "LYNX_CFG_FILE", "/usr/local/lib/lynx.cfg" },
	{ "LYNX_CFG_H", "1" },
	{ "MKDIR_PATH", "/bin/mkdir" },
	{ "MV_PATH", "/bin/mv" },
	{ "NCURSES", "1" },
	{ "OK_GZIP", "1" },
	{ "OK_OVERRIDE", "1" },
	{ "OK_PERMIT", "1" },
	{ "OK_TAR", "1" },
	{ "OK_UUDECODE", "1" },
	{ "OK_ZIP", "1" },
	{ "RM_PATH", "/bin/rm" },
	{ "STDC_HEADERS", "1" },
	{ "SYSTEM_MAIL", "/usr/sbin/sendmail" },
	{ "SYSTEM_MAIL_FLAGS", "-t -oi" },
	{ "TAR_PATH", "/usr/bin/tar" },
	{ "TOUCH_PATH", "/usr/bin/touch" },
	{ "UNCOMPRESS_PATH", "/usr/bin/gunzip" },
	{ "UNIX", "1" },
	{ "UNZIP_PATH", "/usr/bin/unzip" },
	{ "USE_EXTERNALS", "1" },
	{ "UUDECODE_PATH", "/usr/bin/uudecode" },
	{ "ZCAT_PATH", "/usr/bin/zcat" },
	{ "ZIP_PATH", "/usr/bin/zip" },
	{ "lstat", "stat" },
};

#endif /* CFG_DEFS_H */
