/*
 	File:		FixMath.h
 
 	Contains:	Fixed Math Interfaces.
 
 	Version:	Technology:	System 7.5
 				Release:	QuickTime 3.0
 
 	Copyright:	 1985-1998 by Apple Computer, Inc., all rights reserved
 
 	Bugs?:		Please include the the file and version information (from above) with
 				the problem description.  Developers belonging to one of the Apple
 				developer programs can submit bug reports to:
 
 					devsupport@apple.com
 
*/
#ifndef __FIXMATH__
#define __FIXMATH__

#ifndef __MACTYPES__
#include <MacTypes.h>
#endif



#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif



#define fixed1				((Fixed) 0x00010000L)
#define fract1				((Fract) 0x40000000L)
#define positiveInfinity	((long)  0x7FFFFFFFL)
#define negativeInfinity	((long)  0x80000000L)
/*
	Previously in ToolUtils.i.  Moved here because it makes more sense.
*/
#if !OLDROUTINELOCATIONS
EXTERN_API( Fixed )
FixRatio						(short 					numer,
								 short 					denom)								ONEWORDINLINE(0xA869);

EXTERN_API( Fixed )
FixMul							(Fixed 					a,
								 Fixed 					b)									ONEWORDINLINE(0xA868);

EXTERN_API( short )
FixRound						(Fixed 					x)									ONEWORDINLINE(0xA86C);

#endif  /*  !OLDROUTINELOCATIONS */

EXTERN_API( Fract )
Fix2Frac						(Fixed 					x)									ONEWORDINLINE(0xA841);

EXTERN_API( long )
Fix2Long						(Fixed 					x)									ONEWORDINLINE(0xA840);

EXTERN_API( Fixed )
Long2Fix						(long 					x)									ONEWORDINLINE(0xA83F);

EXTERN_API( Fixed )
Frac2Fix						(Fract 					x)									ONEWORDINLINE(0xA842);

EXTERN_API( Fract )
FracMul							(Fract 					x,
								 Fract 					y)									ONEWORDINLINE(0xA84A);

EXTERN_API( Fixed )
FixDiv							(Fixed 					x,
								 Fixed 					y)									ONEWORDINLINE(0xA84D);

EXTERN_API( Fract )
FracDiv							(Fract 					x,
								 Fract 					y)									ONEWORDINLINE(0xA84B);

EXTERN_API( Fract )
FracSqrt						(Fract 					x)									ONEWORDINLINE(0xA849);

EXTERN_API( Fract )
FracSin							(Fixed 					x)									ONEWORDINLINE(0xA848);

EXTERN_API( Fract )
FracCos							(Fixed 					x)									ONEWORDINLINE(0xA847);

EXTERN_API( Fixed )
FixATan2						(long 					x,
								 long 					y)									ONEWORDINLINE(0xA818);

/*
	Frac2X, Fix2X, X2Fix, and X2Frac translate to and from
	the floating point type "extended" (that's what the X is for).
	On the original Mac this was 80-bits and the functions could be
	accessed via A-Traps.  When the 68881 co-processor was added,
	it used 96-bit floating point types, so the A-Traps could not 
	be used.  When PowerPC was added, it used 64-bit floating point
	types, so yet another prototype was added.
*/
#if TARGET_CPU_68K
#if TARGET_RT_MAC_68881
EXTERN_API( long double )
Frac2X							(Fract 					x);

EXTERN_API( long double )
Fix2X							(Fixed 					x);

EXTERN_API( Fixed )
X2Fix							(long double 			x);

EXTERN_API( Fract )
X2Frac							(long double 			x);

#else
EXTERN_API( long double )
Frac2X							(Fract 					x)									ONEWORDINLINE(0xA845);

EXTERN_API( long double )
Fix2X							(Fixed 					x)									ONEWORDINLINE(0xA843);

EXTERN_API( Fixed )
X2Fix							(long double 			x)									ONEWORDINLINE(0xA844);

EXTERN_API( Fract )
X2Frac							(long double 			x)									ONEWORDINLINE(0xA846);

#endif  /* TARGET_RT_MAC_68881 */

#else
EXTERN_API( double )
Frac2X							(Fract 					x);

EXTERN_API( double )
Fix2X							(Fixed 					x);

EXTERN_API( Fixed )
X2Fix							(double 				x);

EXTERN_API( Fract )
X2Frac							(double 				x);

#endif  /* TARGET_CPU_68K */


#if TARGET_CPU_PPC || !TARGET_OS_MAC
EXTERN_API_C( short )
WideCompare						(const wide *			target,
								 const wide *			source);

EXTERN_API_C( WidePtr )
WideAdd							(wide *					target,
								 const wide *			source);

EXTERN_API_C( WidePtr )
WideSubtract					(wide *					target,
								 const wide *			source);

EXTERN_API_C( WidePtr )
WideNegate						(wide *					target);

EXTERN_API_C( WidePtr )
WideShift						(wide *					target,
								 long 					shift);

EXTERN_API_C( unsigned long )
WideSquareRoot					(const wide *			source);

EXTERN_API_C( WidePtr )
WideMultiply					(long 					multiplicand,
								 long 					multiplier,
								 wide *					target);

/* returns the quotient */
EXTERN_API_C( long )
WideDivide						(const wide *			dividend,
								 long 					divisor,
								 long *					remainder);

/* quotient replaces dividend */
EXTERN_API_C( WidePtr )
WideWideDivide					(wide *					dividend,
								 long 					divisor,
								 long *					remainder);

EXTERN_API_C( WidePtr )
WideBitShift					(wide *					src,
								 long 					shift);

#endif  /* TARGET_CPU_PPC ||  !TARGET_OS_MAC */



#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif /* __FIXMATH__ */

