/* QDPictHandle.m created by seb on Fri 03-Apr-1998 */

#import "QDPictHandle.h"
#include "QuickDraw.h"

@implementation QDPictHandle

-(id)initWithPict:(PicHandle)picture {
  picture_ = picture;
  return self;
}

-(PicHandle)pictHandle {
  return picture_;
}

+(id)makeWithPicHandle:(PicHandle)picture {
  QDPictHandle* pic = [[QDPictHandle alloc] initWithPict:picture];
  return [pic autorelease];
}

-(void)killPicture {
  if (picture_)
    KillPicture( picture_ );
}

- (NSString *)description {
  return (picture_) ?
 [NSString stringWithFormat:@"{\n\tpicSize:%d,\n\tpicFrame:{\n\t\ttop:%d\n\t\tbottom:%d\n\t\tright:%d\n\t\tleft:%d\n\t}\n",
    (**picture_).picSize,
    (**picture_).picFrame.top,
    (**picture_).picFrame.bottom,
    (**picture_).picFrame.right,
   (**picture_).picFrame.left
  ]:@"<nil>";
}
@end
