/* QTMovie.m */

#import "QTMovie.h"

// utilities
#include "TextUtils.h"
#include "EndianUtilities.h"

// mac
#include <FixMath.h>
#include <Fonts.h>
#include <GXTypes.h>
#include <ImageCodec.h>
#include <ImageCompression.h>
#include <MacTypes.h>
#include <MacWindows.h>
#include <Movies.h>
#include <QuickDraw.h>
#include <QuickTimeComponents.h>
#include <StandardFile.h>
#include <Sound.h>
#include <ConditionalMacros.h>

// methodes privees
@interface QTMovie (PrivateMethods)
//- (void)createVideoMovie;
- (void)CreateVideoTrack:(NSRect)aRect;
- (void)AddVideoSamplesToMedia:(Media)theMedia withRect:(Rect*)trackFrame;
- (void)DrawFrame:(Rect*)trackFrame withIndex:(long)curSample;
- (NSString*)chooseFile;
@end

@implementation QTMovie

- (id)initWithFrame:(NSRect)frameRect {

  OSErr err;
  Handle myHandle;

  movie_ = NewMovie(newMovieActive);	
  myHandle = NewHandleClear(4);

  if ((err=MemError())!=noErr)
    printf("error NewHandle = %d\n",err );

  err = SetMovieDefaultDataRef(movie_,myHandle,HandleDataHandlerSubType);

  if (err!=noErr)
    printf("error NewMovieFromHandle = %d\n",err );

  [self CreateVideoTrack:frameRect];

  return self;
}
/*
- (void)createVideoMovie {

  FSSpec   fileSpec;
  char     fullPath[255];
  long	   myFlags = createMovieFileDeleteCurFile;
  OSErr    myErr = noErr;
  short	   myResRefNum = 0;
 
  [self setFileName:[self chooseFile]];

  strcpy(fullPath,[filename_ cString]);
  c2pstr(fullPath);

  FSMakeFSSpec(0,0L,fullPath,&fileSpec);

#ifdef TARGET_OS_WIN32
  // don't create a resource fork under Windows
  myFlags |= createMovieFileDontCreateResFile;
#endif

  // create a movie file for the destination movie
  myErr = CreateMovieFile(&fileSpec, OSTypeConst('TVOD'), smCurrentScript, myFlags, &myResRefNum, &movie_);
  if (myErr != noErr)
    printf("CreateMovieFile error => %d\n",myErr);

  [self CreateVideoTrack:NSMakeRect(0,0,100,100)];

}
*/
#define kVideoTimeScale 600
#define kTrackStart 0
#define kMediaStart 0
#define kFix1 0x00010000

-(void)CreateVideoTrack:(NSRect)aRect {

  Track theTrack;
  Media theMedia;
  OSErr err = noErr;
  Rect trackFrame;

  trackFrame.top    = aRect.origin.y;
  trackFrame.left   = aRect.origin.x;
  trackFrame.bottom = aRect.size.height;
  trackFrame.right  = aRect.size.width;

  theTrack = NewMovieTrack (movie_,
                            FixDiv(trackFrame.right,1),
                            FixDiv(trackFrame.bottom,1),
                            kNoVolume);

  if ((err=GetMoviesError())!=noErr)
    printf("error NewMovieTrack = %d\n",err );

  theMedia = NewTrackMedia (theTrack, VideoMediaType,
                            600, // Video Time Scale
                            0, 0);

  if ((err=GetMoviesError())!=noErr)
    printf("error NewTrackMedia = %d\n",err );

  err = BeginMediaEdits (theMedia);

  if (err!=noErr)
    printf("error BeginMediaEdits = %d\n",err );

  [self AddVideoSamplesToMedia:theMedia withRect:&trackFrame];

  err = EndMediaEdits (theMedia);

  if (err!=noErr)
    printf("error EndMediaEdits = %d\n",err );

  err = InsertMediaIntoTrack (theTrack, 0,/* track start time */
    0, /* media start time */
    GetMediaDuration (theMedia),
    kFix1);

  if (err!=noErr)
    printf("error InsertMediaIntoTrack = %d\n",err );

}

#define kSampleDuration 240
/* video frames last 240 * 1/600th of a second */
#define kNumVideoFrames 29
#define kNoOffset 0
#define kMgrChoose 0
#define kSyncSample 0
#define kAddOneVideoSample 1
#define kPixelDepth 16

-(void)AddVideoSamplesToMedia:(Media)theMedia withRect:(Rect*)trackFrame {

  long maxCompressedSize;
  GWorldPtr theGWorld = 0;
  long curSample;
  Handle compressedData = 0;
  Ptr compressedDataPtr;
  ImageDescriptionHandle imageDesc = 0;
  CGrafPtr oldPort;
  GDHandle oldGDeviceH;
  OSErr err = noErr;
  PixMapHandle	myPixMap = NULL;

  err = QTNewGWorld (&theGWorld,
                   32, // pixel depth 
                   trackFrame,
                   0,
                   0,
                   useTempMem);

  if (err!=noErr)
    printf("error NewGWorld = %d\n",err );

  myPixMap = GetGWorldPixMap(theGWorld);

  LockPixels (myPixMap);

  err = GetMaxCompressionSize (myPixMap,
                               trackFrame,
                               0, /* let ICM choose depth */
                               codecNormalQuality,
                               FOUR_CHAR_CODE('rle '),
                               (CompressorComponent) anyCodec,
                               &maxCompressedSize);

  if (err!=noErr)
    printf("error GetMaxCompressionSize = %d\n",err );

  compressedData = NewHandle(maxCompressedSize);

  if ((err=MemError())!=noErr)
    printf("error NewHandle = %d\n",err );

  MoveHHi( compressedData );
  HLock( compressedData );
  compressedDataPtr = StripAddress( *compressedData );
  imageDesc = (ImageDescriptionHandle)NewHandle(4);

  if ((err=MemError())!=noErr)
    printf("error NewHandle = %d\n",err );

  GetGWorld (&oldPort, &oldGDeviceH);
  SetGWorld (theGWorld, 0);
  for (curSample = 1; curSample < 30; curSample++)
  {
    EraseRect (trackFrame);
    [self DrawFrame:trackFrame withIndex:curSample];
    err = CompressImage (myPixMap,
                         trackFrame,
                         codecNormalQuality,
                         FOUR_CHAR_CODE('rle '),
                         imageDesc,
                         compressedDataPtr );

    if (err!=noErr)
      printf("error CompressImage = %d\n",err );

    //EndianUtils_ImageDescription_NtoB(imageDesc);

    err = AddMediaSample(theMedia,
                         compressedData,
                         0, /* no offset in data */
                         (**imageDesc).dataSize,
                         60, /* frame duration = 1/10 sec */
                         (SampleDescriptionHandle)imageDesc,
                         1, /* one sample */
                         0, /* self-contained samples */
                         0);

    if (err!=noErr)
      printf("error AddMediaSample = %d\n",err );
  }
  SetGWorld (oldPort, oldGDeviceH);
  if (imageDesc) DisposeHandle ((Handle)imageDesc);
  if (compressedData) DisposeHandle (compressedData);
  if (theGWorld) DisposeGWorld (theGWorld);
}

-(void)DrawFrame:(Rect*)trackFrame withIndex:(long)curSample {
  Str255 numStr;
  ForeColor( redColor );
  PaintRect( trackFrame );
  ForeColor( blueColor );
  NumToString (curSample, numStr);
  MoveTo ( trackFrame->right / 2, trackFrame->bottom / 2);
  TextSize ( trackFrame->bottom / 3);
  DrawString (numStr);
}

- (NSString*)chooseFile {
  
  int result;
  NSSavePanel *sPanel = [NSSavePanel savePanel];
  NSString *filename;

  [sPanel setRequiredFileType:@"mov"];
  
   result = [sPanel runModalForDirectory:NSHomeDirectory() file:@"movie.mov"];
                                 
  if (result != NSOKButton)
      return nil;

  filename = [sPanel filename];

  return filename;
}
/*
- (id)init {

  [self createVideoMovie];
  
  return self;
}*/

- (id)initWithSprite {
  spriteManager_ = [[QTSpriteManager alloc] init];
  [self setFileName:[self chooseFile]];
  movie_ = [spriteManager_ CreateSampleSpriteMovie:[self filename]];
  return self;
}

- (id)initFromFile:(NSString *)filename
{
  short mfMovie;
  OSErr err;
  FSSpec fileSpec;
  char fullPath[255];
  
  
  filename_ = filename;
  [filename_ retain];

  strcpy(fullPath,[filename cString]);
  c2pstr(fullPath);

  FSMakeFSSpec(0,0L,fullPath,&fileSpec);

  
  err = OpenMovieFile (&fileSpec, &mfMovie, OF_READ);
  if (err!=noErr)
    NSLog(@"OpenMovieFile error => %d",err);
  
  err = NewMovieFromFile (&movie_, mfMovie, NULL, NULL, 0, NULL);
  if (err!=noErr)
    NSLog(@"NewMovieFromFile error => %d",err);

  err = CloseMovieFile (mfMovie);
  if (err!=noErr)
    NSLog(@"CloseMovieFile error => %d",err);

  if(!movie_){
    NSLog(@"Movie not opened !");
    return nil;    
  }
 
  return self;
}

- (void)dealloc
{
// Destroy the movie
  if (movie_!=NULL)
    DisposeMovie (movie_);

  if (spriteManager_)
    [spriteManager_ release];
  
  [filename_ release];
  [super dealloc];
}

- (Movie)movie
{
    return movie_;
}

- (NSString *)filename
{
    return filename_;
}

- (float)currentTime
{
    TimeRecord trRecord;
  TimeValue tvTime = GetMovieTime(movie_, &trRecord);
  return (float)((float)tvTime/(float)GetMovieTimeScale (movie_));
}

- (int)currentTimeValue
{
    TimeRecord trRecord;
  TimeValue tvTime = GetMovieTime(movie_, &trRecord);
    return tvTime;
}

- (int)preferredRate
{
  return GetMoviePreferredRate(movie_);
}

- (int)preferredVolume
{
  return GetMoviePreferredVolume(movie_);
}

- (int)movieDuration
{
  return GetMovieDuration(movie_);
}

-(int)movieRate
{
  return GetMovieRate(movie_);
}

- (int)movieTimeScale
{
  return GetMovieTimeScale(movie_);
}

- (PicHandle)currentImage
{
    PicHandle phMyPicHandle;
    TimeRecord trRecord;
    TimeValue tvTime = GetMovieTime(movie_, &trRecord);

    phMyPicHandle = GetMoviePict (movie_, tvTime);

    return phMyPicHandle;
}

- (void)setFileName:(NSString *)aFileName {
  if (filename_) [filename_ release];
  filename_ = aFileName;
  [filename_ retain];
}

@end
