#import "QTView.h"
#include "QTML.h"
#include "FixMath.h"
#include "ImageCompression.h"
#include "Endian.h"


@implementation QTView

extern PicHandle image;
static BOOL first = YES;

static QTView* theMovieView;

- (id)movie {
  return movie_;
}

- (void)drawRect:(NSRect)aRect
{

  if (movie_) {
/*    static PicHandle image = 0;

    if(image)
        DisposeHandle((Handle)image);
    if((image = [movie_ currentImage]) != (PicHandle)nil)
      {
        Rect rcMovie;
        NSRect aRect = [[self superview] convertRect:_frame toView:nil];

        rcMovie.left = aRect.origin.x ;
        rcMovie.top = [_window frame].size.height - (aRect.size.height + aRect.origin.y);
        rcMovie.right = rcMovie.left + aRect.size.width;
        rcMovie.bottom = rcMovie.top + aRect.size.height;

        DrawPicture (image, &rcMovie);
      }
*/
  }
  else if (image) {

    Rect rcMovie;
    NSRect aRect = [[self superview] convertRect:_frame toView:nil];
    //CGrafPtr windowPort,oldPort;

    rcMovie.left = aRect.origin.x ;
    rcMovie.top = [_window frame].size.height - (aRect.size.height + aRect.origin.y);
    rcMovie.right = rcMovie.left + aRect.size.width;
    rcMovie.bottom = rcMovie.top + aRect.size.height;

    //GetPort(&oldPort);
    
    //windowPort = GetNativeWindowPort([[self window] windowHandle]);
    //MacSetPort(windowPort);
    DrawPicture (image, &rcMovie);
    
    //MacSetPort(oldPort);

  }
  else {
    PSsetgray(NSWhite);
    NSRectFill(aRect);
  }

  return;
}

- (id)initWithFrame:(NSRect)frameRect {

  [super initWithFrame:frameRect];
  
  theMovieView = self;
  
  return self;
}

- (void)dealloc {
  
  if (controller_)
    DisposeMovieController (controller_);
  
  if (movie_)
    [movie_ release];

  [super dealloc];
}


long FAR PASCAL _export WndProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    // Return to Windows
  return [theMovieView wndProc:hWnd :message :wParam :lParam];
}

- (long)wndProc: (HWND)hWnd :(UINT)message :(WPARAM) wParam :(LPARAM) lParam
{
  MSG	msg;
  EventRecord	macEvent;
  LONG thePoints = GetMessagePos();

  msg.hwnd = hWnd;
  msg.message = message;
  msg.wParam = wParam;
  msg.lParam = lParam;
  msg.time = GetMessageTime();
  msg.pt.x = LOWORD(thePoints);
  msg.pt.y = HIWORD(thePoints);
  NativeEventToMacEvent(&msg, &macEvent);  // Convert the message to a QTML event

  // Drive the movie controller
  if (MCIsPlayerEvent(controller_,(const EventRecord *)&macEvent))
    return 0;
  else  {
    // Process the Windows NT message
    switch (message)
       {
         case WM_DESTROY:
             PostQuitMessage (0);
             return 0;
       }
     // Return to Windows
     return (*windProc)(hWnd, message, wParam, lParam);
  }
 }

- (void)setQTMovie:(id)aQTMovie
{
    Rect rcMovie;
    LONG lfxRate;
    NSRect aRect;

    if (controller_) {
      DisposeMovieController (controller_);
      controller_ = nil;
    }

    if (movie_)
      [movie_ release];

    movie_ = aQTMovie;
    [movie_ retain];

    aRect = [[self superview] convertRect:_frame toView:nil];

    rcMovie.left = aRect.origin.x ;
    rcMovie.top = [_window frame].size.height - (aRect.size.height + aRect.origin.y);
    rcMovie.right = rcMovie.left + aRect.size.width;
    rcMovie.bottom = rcMovie.top + aRect.size.height;

    if(!controller_)
      {
        rcMovie.bottom -= 16;
// Instantiate the movie controller
        controller_ = NewMovieController ([movie_ movie], &rcMovie,
                                           mcTopLeftMovie + mcScaleMovieToFit);
       
// Set an winProc filter, passing in the parent window handle
        if (first) {
          windProc = (WndProcFunc *) GetWindowLong([[self window] windowHandle], GWL_WNDPROC);
          SetWindowLong ([[self window] windowHandle], GWL_WNDPROC, (LONG)WndProc);
          theMovieView = self;
          first = NO;
        }
 // Set an action filter, passing in the parent window handle
        //MCSetActionFilter (controller_, actionFilter, (LONG) ((LPVOID) [[self window] windowHandle]));
      }
/*    else
      {
        POINT ptUpperLeft;
        ptUpperLeft.x = rcMovie.left;
        ptUpperLeft.y = rcMovie.top;
        MCSetControllerBoundsRect(controller_, &rcMovie);
      }
*/
// Make the movie played initially
    lfxRate = GetMoviePreferredRate ([movie_ movie]);
    MCDoAction (controller_, mcActionPlay, (LPVOID)lfxRate);
// Eliminate the grow box
    rcMovie.bottom = 0;
    rcMovie.top = 0;
    rcMovie.left = 0;
    rcMovie.right = 0;
    MCDoAction (controller_, mcActionSetGrowBoxBounds, &rcMovie);
// Make the movie active
   SetMovieActive ([movie_ movie], TRUE);
}


- (BOOL)addTweenMatrixTrack{

  OSErr                   err = noErr;

  Track                   tweenTrack;
  Media                   tweenMedia;
  SampleDescriptionHandle desc = (SampleDescriptionHandle)NewHandleClear(sizeof(SampleDescription));

  QTAtom                  tweenAtom;
  QTAtomContainer         container = nil;
  MatrixRecord            tweenDataMatrix[2];
  QTAtomType              tweenType;
  TimeValue               duration = [movie_ movieDuration];

  Track                   videoTrack;

  int i,j;
  
  // 1 - make the tween track

  printf("make the matrix tween track\n");

  tweenTrack = NewMovieTrack([movie_ movie],0,0,kNoVolume);
  tweenMedia = NewTrackMedia(tweenTrack,TweenMediaType,[movie_ movieTimeScale],nil,0);

  (**desc).descSize = sizeof(SampleDescription);

  SetIdentityMatrix(&(tweenDataMatrix[0]));
  SetIdentityMatrix(&(tweenDataMatrix[1]));
  // params = 0.5,0.8,100,100
  ScaleMatrix(&(tweenDataMatrix[1]), FixRatio(1, 2), FixRatio(4, 5), Long2Fix(100), Long2Fix(100));
  // params = 90,100,100
  RotateMatrix(&(tweenDataMatrix[1]),Long2Fix(90),Long2Fix(100),Long2Fix(100));
  
  for (i=0;i<3;i++) for (j=0;j<3;j++) {
    tweenDataMatrix[0].matrix[i][j] = EndianU32_NtoB(tweenDataMatrix[0].matrix[i][j]);
    tweenDataMatrix[1].matrix[i][j] = EndianU32_NtoB(tweenDataMatrix[1].matrix[i][j]);
  }
    
  QTNewAtomContainer(&container);

  tweenType = EndianU32_NtoB(kTweenTypeMatrix);

  QTInsertChild(container,kParentAtomIsContainer,kTweenEntry,1,0,0,nil,&tweenAtom);
  QTInsertChild(container,tweenAtom,kTweenType,1,0,sizeof(tweenType),&tweenType,nil);
  QTInsertChild(container,tweenAtom,kTweenData,1,0,sizeof(MatrixRecord)*2,tweenDataMatrix,nil);

  BeginMediaEdits(tweenMedia);
  err = AddMediaSample(tweenMedia,container,0,GetHandleSize(container),duration,desc,1,0,nil);
  if (err!=noErr)
    printf("error => AddMediaSample: %d\n",err);
  EndMediaEdits(tweenMedia);

  DisposeHandle((Handle)desc);
  QTDisposeAtomContainer(container);

  err = InsertMediaIntoTrack(tweenTrack,0,0,duration,fixed1);
  if (err!=noErr)
    printf("error => InsertMediaIntoTrack: %d\n",err);

  // 2 - link it to the matrix of the video track

  printf("link it to the matrix of the video track\n");

  videoTrack = GetMovieIndTrackType([movie_ movie],1,VideoMediaType,movieTrackEnabledOnly|movieTrackMediaType);

  if (videoTrack) {
    long referenceIndex;
    
    if ((err=AddTrackReference(videoTrack,tweenTrack,kTrackModifierReference,&referenceIndex)) == noErr) {
      QTAtomContainer inputMap = nil;
      Media myVideoMedia = GetTrackMedia(videoTrack);

      GetMediaInputMap(myVideoMedia,&inputMap);
      if (inputMap == nil) QTNewAtomContainer(&inputMap);

      if (inputMap != nil)
      {
        QTAtom inputAtom;
        OSType inputType = EndianU32_NtoB(kTrackModifierTypeMatrix);
        long tweenID = EndianU32_NtoB((long)1);

        err = QTInsertChild(inputMap,kParentAtomIsContainer,kTrackModifierInput,referenceIndex,0,0,nil,&inputAtom);
        if (err!=noErr) printf("error => QTInsertChild: %d\n",err);
        err = QTInsertChild(inputMap,inputAtom,kTrackModifierType,1,0,sizeof(inputType),&inputType,nil);
        if (err!=noErr) printf("error => QTInsertChild: %d\n",err);
       err = QTInsertChild(inputMap,inputAtom,kInputMapSubInputID,1,0,sizeof(tweenID),&tweenID,nil);
       if (err!=noErr) printf("error => QTInsertChild: %d\n",err);

        err = SetMediaInputMap(GetTrackMedia(videoTrack),inputMap);
        if (err!=noErr)
          printf("error => SetMediaInputMap: %d\n",err);

        QTDisposeAtomContainer(inputMap);

        printf("end of addTweenTrack\n");

        return YES;
      }
    }
    else printf("error => AddTrackReference: %d\n",err);
  }
  else printf("error => GetMovieIndTrackType returned nil\n");

  return NO;
}

- (BOOL)addTweenTrack {

  OSErr                   err = noErr;
  
  Track                   tweenTrack;
  Media                   tweenMedia;
  SampleDescriptionHandle desc = (SampleDescriptionHandle)NewHandleClear(sizeof(SampleDescription));

  QTAtom                  tweenAtom;
  QTAtomContainer         container = nil;
  short                   tweenDataShort[2];
  QTAtomType              tweenType;
  TimeValue               duration = [movie_ movieDuration];
  
  Track                   soundTrack;
  
  // 1 - make the tween track

  printf("make the tween track\n");
  
  tweenTrack = NewMovieTrack([movie_ movie],0,0,kNoVolume);
  tweenMedia = NewTrackMedia(tweenTrack,TweenMediaType,[movie_ movieTimeScale],nil,0);

  (**desc).descSize = sizeof(SampleDescription);

  tweenDataShort[0] = EndianU16_NtoB((short)512);
  tweenDataShort[1] = EndianU16_NtoB((short)0);

  QTNewAtomContainer(&container);

  tweenType = EndianU32_NtoB(kTweenTypeShort);

  QTInsertChild(container,kParentAtomIsContainer,kTweenEntry,1,0,0,nil,&tweenAtom);
  QTInsertChild(container,tweenAtom,kTweenType,1,0,sizeof(tweenType),&tweenType,nil);
  QTInsertChild(container,tweenAtom,kTweenData,1,0,sizeof(short)*2,tweenDataShort,nil);
  
  BeginMediaEdits(tweenMedia);
  err = AddMediaSample(tweenMedia,container,0,GetHandleSize(container),duration,desc,1,0,nil);
  if (err!=noErr)
    printf("error => AddMediaSample: %d\n",err);
  EndMediaEdits(tweenMedia);

  DisposeHandle((Handle)desc);
  QTDisposeAtomContainer(container);

  err = InsertMediaIntoTrack(tweenTrack,0,0,duration,fixed1);
  if (err!=noErr)
    printf("error => InsertMediaIntoTrack: %d\n",err);
  
  // 2 - link it to the volume of the sound track

  printf("link it to the volume of the sound track\n");
  
  soundTrack = GetMovieIndTrackType([movie_ movie],1,AudioMediaCharacteristic,movieTrackCharacteristic | movieTrackEnabledOnly);

  if (soundTrack) {
    long referenceIndex;
    
    if (AddTrackReference(soundTrack,tweenTrack,kTrackModifierReference,&referenceIndex) == noErr) {
      QTAtomContainer inputMap = nil;
      Media mySoundMedia = GetTrackMedia(soundTrack);

      GetMediaInputMap(mySoundMedia,&inputMap);
      if (inputMap == nil) QTNewAtomContainer(&inputMap);

      if (inputMap != nil) {
        QTAtom inputAtom;
        OSType inputType = EndianU32_NtoB(kTrackModifierTypeVolume);
        long tweenID = EndianU32_NtoB((long)1);

        QTInsertChild(inputMap,kParentAtomIsContainer,kTrackModifierInput,referenceIndex,0,0,nil,&inputAtom);
        QTInsertChild(inputMap,inputAtom,kTrackModifierType,1,0,sizeof(inputType),&inputType,nil);
        QTInsertChild(inputMap,inputAtom,kInputMapSubInputID,1,0,sizeof(tweenID),&tweenID,nil);

        err = SetMediaInputMap(GetTrackMedia(soundTrack),inputMap);
        if (err!=noErr)
          printf("error => SetMediaInputMap: %d\n",err);

        QTDisposeAtomContainer(inputMap);

        printf("end of addTweenTrack\n");
        
        return YES;
      }
    }
  }
  
  return NO;
}

- (NSSize)windowWillResize:(NSWindow *)sender toSize:(NSSize)proposedFrameSize
{
    return proposedFrameSize;
}

- (void)windowDidResize:(NSNotification *)aNotification
{    
    if(movie_)
      {
        Rect rcMovie;
        NSRect aRect = [[self superview] convertRect:_frame toView:nil];

        rcMovie.left = aRect.origin.x ;
        rcMovie.top = [_window frame].size.height - (aRect.size.height + aRect.origin.y);
        rcMovie.right = rcMovie.left + aRect.size.width;
        rcMovie.bottom = rcMovie.top + aRect.size.height;
        MCSetControllerBoundsRect(controller_, &rcMovie);
      }
}


@end
