#ifndef _SPRITEUTILITIES_
#define _SPRITEUTILITIES_
#ifndef __MOVIES__
	#include <Movies.h>
#endif
#endif

// _____________________ Sprite Utilities _____________________ //

// set sprite properties for non-nil parameters, overriding or adding atoms as neccessary
OSErr SetSpriteData( QTAtomContainer sprite, Point *location, short *visible, short *layer, short *imageIndex, 
						ModifierTrackGraphicsModeRecord *graphicsMode, StringPtr spriteName, 
						QTAtomContainer actionAtoms );
// add a sprite to a sample
OSErr AddSpriteToSample( QTAtomContainer theSample, QTAtomContainer theSprite, QTAtomID spriteID );

// add a sprite key frame sample to sprite track's media
OSErr AddSpriteSampleToMedia( Media theMedia, QTAtomContainer sample, TimeValue duration, Boolean isKeyFrame,
						TimeValue *sampleTime );

// add a sprite key frame sample--and compress it in the process--to sprite track's media
OSErr AddCompressedSpriteSampleToMedia( Media theMedia, QTAtomContainer sample, TimeValue duration, Boolean isKeyFrame,
						OSType dataCompressorType,
						TimeValue *sampleTime );
						
// compress a PICT with animation compressor and add image data to a sprite key sample's images container atom
/*OSErr AddPICTImageToKeyFrameSample( QTAtomContainer keySample, short pictID, RGBColor *keyColor, QTAtomID id, 
						FixedPoint *registrationPoint, StringPtr imageName );
*/						
// add compressed image data to a sprite key sample's images container atom
OSErr AddCompressedImageToKeyFrameSample( QTAtomContainer keySample, ImageDescriptionHandle idh, long dataSize, Ptr compressedDataPtr,
						QTAtomID imageID, FixedPoint *registrationPoint, StringPtr imageName );

// assign image group ID's to the images in a key frame sample
OSErr AssignImageGroupIDsToKeyFrame( QTAtomContainer keySample );

