/* beziertest.c -- Test program for dashes
 * Copyright (C) 1998 FastIO Systems, All Rights Reserved.
 * For conditions of use, license, and distribution, see LICENSE.txt or LICENSE.pdf.

cc -Wall -o beziertest beziertest.c -lcpdf

1998-09-12  [IO]
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <cpdflib.h>


void main(int argc, char *argv[])
{
float x0 = 1.0, y0 = 1.0;
float x1 = 1.2, y1 = 1.5;
float x2 = 2.8, y2 = 2.2;
float x3 = 3.0, y3 = 1.2;
float fontsize = 12.0;
float markersize = 4.0;

    /* == Initialization == */
    cpdf_open(0);
    cpdf_enableCompression(YES);		/* use Flate/Zlib compression */
    cpdf_init();
    cpdf_pageInit(1, PORTRAIT, LETTER, LETTER);		/* page orientation */
    cpdf_translate(0.0, 6.5);

    /* First Bezier curve example */
    cpdf_setgray(0.0);
    cpdf_setlinewidth(1.5);
    cpdf_moveto(x0, y0);
    cpdf_curveto(x1, y1, x2, y2, x3, y3);
    cpdf_stroke();

    cpdf_setdash("[2 3] 0");
    cpdf_setlinewidth(0.3);
    cpdf_moveto(x0, y0);
    cpdf_lineto(x1, y1);
    cpdf_moveto(x3, y3);
    cpdf_lineto(x2, y2);
    cpdf_stroke();
    cpdf_nodash();

    cpdf_marker(x1, y1, 0, markersize);		/* control points */
    cpdf_marker(x2, y2, 0, markersize);

    cpdf_setgrayFill(1.0);
    cpdf_marker(x0, y0, 3, markersize);		/* end points */
    cpdf_marker(x3, y3, 3, markersize);

    cpdf_setgrayFill(0.0);
    cpdf_beginText(0);
    cpdf_setFont("Helvetica-Oblique", "MacRomanEncoding", fontsize);
    cpdf_text(x0-0.15, y0-0.25, 0.0, "x0, y0");	/* cpdf_text() may be repeatedly used */
    cpdf_text(x3-0.15, y3-0.25, 0.0, "x3, y3");	/* cpdf_text() may be repeatedly used */
    cpdf_text(x1-0.15, y1+0.1, 0.0, "x1, y1");	/* cpdf_text() may be repeatedly used */
    cpdf_text(x2-0.15, y2+0.1, 0.0, "x2, y2");	/* cpdf_text() may be repeatedly used */
    cpdf_endText();

    /* The second Bezier example */
    x0 = 4.0; y0 = 1.0;
    x1 = 4.3; y1 = 2.2;
    x2 = 5.8; y2 = 0.7;
    x3 = 6.0; y3 = 1.7;

    cpdf_setgray(0.0);
    cpdf_nodash();
    cpdf_setlinewidth(1.5);
    cpdf_moveto(x0, y0);
    cpdf_curveto(x1, y1, x2, y2, x3, y3);
    cpdf_stroke();

    cpdf_setdash("[2 3] 0");
    cpdf_setlinewidth(0.3);
    cpdf_moveto(x0, y0);
    cpdf_lineto(x1, y1);
    cpdf_moveto(x3, y3);
    cpdf_lineto(x2, y2);
    cpdf_stroke();
    cpdf_nodash();

    cpdf_marker(x1, y1, 0, markersize);		/* control points */
    cpdf_marker(x2, y2, 0, markersize);

    cpdf_setgrayFill(1.0);
    cpdf_marker(x0, y0, 3, markersize);		/* end points */
    cpdf_marker(x3, y3, 3, markersize);

    cpdf_setgrayFill(0.0);
    cpdf_beginText(0);
    cpdf_setFont("Helvetica-Oblique", "MacRomanEncoding", fontsize);
    cpdf_text(x0-0.15, y0-0.25, 0.0, "x0, y0");	/* cpdf_text() may be repeatedly used */
    cpdf_text(x1-0.15, y1+0.1, 0.0, "x1, y1");	/* cpdf_text() may be repeatedly used */
    cpdf_text(x2-0.15, y2-0.25, 0.0, "x2, y2");	/* cpdf_text() may be repeatedly used */
    cpdf_text(x3-0.15, y3+0.1, 0.0, "x3, y3");	/* cpdf_text() may be repeatedly used */
    cpdf_endText();

    cpdf_finalizeAll();			/* PDF file/memstream is actually written here */
    cpdf_savePDFmemoryStreamToFile("bezier.pdf");

    /* == Clean up == */
    cpdf_close();			/* shut down */
    cpdf_launchPreview();		/* launch Acrobat/PDF viewer on the output file */
}

