/* dashtest.c -- Test program for dashes
 * Copyright (C) 1998 FastIO Systems, All Rights Reserved.
 * For conditions of use, license, and distribution, see LICENSE.txt or LICENSE.pdf.

cc -Wall -o dashtest -I/usr/local/include dashtest.c -lcpdf

1998-09-11  [IO]
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <cpdflib.h>

static char *dashpattern[] = {
	"[2  2] 0",
	"[4  4] 0",
	"[8  8] 0",
	"[8  8] 4",
	"[8  8] 8",
	"[12  4] 0",
	"[16  3  4  3] 0",
	"[13  3  2  3  2  3] 0",
	"[ ] 0"
};

#define Ndash	9

void main(int argc, char *argv[])
{
int i;
float ybump = 0.22;
float x = 1.0, y = 3.0;
float fontsize = 12.0;

    /* == Initialization == */
    cpdf_open(0);
    cpdf_enableCompression(YES);		/* use Flate/Zlib compression */
    cpdf_init();
    cpdf_pageInit(1, PORTRAIT, LETTER, LETTER);		/* page orientation */
    cpdf_translate(0.0, 6.5);

    cpdf_setgray(0.0);
    for(i=0; i< Ndash; i++) {
	cpdf_setdash(dashpattern[i]);
	cpdf_moveto(x, y);
	cpdf_lineto(x+2.0, y);
	cpdf_stroke();
	y -= ybump;
    }
    
    x = 3.1; y = 3.0 - fontsize*0.3/inch;
    cpdf_beginText(0);
    cpdf_setFont("Helvetica", "MacRomanEncoding", fontsize);
    for(i=0; i< Ndash; i++) {
        cpdf_text(x, y, 0.0, dashpattern[i]);	/* cpdf_text() may be repeatedly used */
	y -= ybump;
    }
    cpdf_endText();

    cpdf_finalizeAll();			/* PDF file/memstream is actually written here */
    cpdf_savePDFmemoryStreamToFile("dashtest.pdf");

    /* == Clean up == */
    cpdf_close();			/* shut down */
    cpdf_launchPreview();		/* launch Acrobat/PDF viewer on the output file */
}

