/* filltest.c -- non-zero winding rule for fill
 * Copyright (C) 1998 FastIO Systems, All Rights Reserved.
 * For conditions of use, license, and distribution, see LICENSE.txt or LICENSE.pdf.

cc -Wall -o filltest filltest.c -lcpdf

1998-09-05  [IO]
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <cpdflib.h>

void main(int argc, char *argv[])
{
float r1=0.3, r2 = 0.6;
float xorig = 1.5, yorig = 1.5;
float psize = 6.0;

    /* == Initialization == */
    cpdf_open(0);
    cpdf_enableCompression(YES);		/* use Flate/Zlib compression */
    cpdf_init();
    cpdf_pageInit(1, PORTRAIT, LETTER, LETTER);		/* page orientation */
    cpdf_translate(0.0, 6.5);


    /* Demonstration for non-zero winding rule for fill operator */
    xorig = 1.5;
    yorig = 1.5;
    cpdf_setgrayStroke(0.0);				/* Black */
    cpdf_setrgbcolorFill(0.7, 0.7, 1.0);
    cpdf_arc(xorig, yorig, r1, 0.0, 360.0, 1); cpdf_closepath();  /* CCW */
    cpdf_arc(xorig, yorig, r2, 0.0, 360.0, 1); cpdf_closepath();  /* CCW */
    cpdf_fillAndStroke();
    cpdf_setgrayFill(0.0);
    cpdf_pointer(xorig+r1, yorig, PTR_UP, psize);
    cpdf_pointer(xorig-r1, yorig, PTR_DOWN, psize);
    cpdf_pointer(xorig+r2, yorig, PTR_UP, psize);
    cpdf_pointer(xorig-r2, yorig, PTR_DOWN, psize);

    xorig = 3.0;
    yorig = 1.5;
    cpdf_setrgbcolorFill(0.7, 0.7, 1.0);
    cpdf_arc(xorig, yorig, r1, 360.0, 0.0, 1); cpdf_closepath();  /* CW */
    cpdf_arc(xorig, yorig, r2, 0.0, 360.0, 1); cpdf_closepath();  /* CCW */
    cpdf_fillAndStroke();
    cpdf_setgrayFill(0.0);
    cpdf_pointer(xorig+r1, yorig, PTR_DOWN, psize);
    cpdf_pointer(xorig-r1, yorig, PTR_UP, psize);
    cpdf_pointer(xorig+r2, yorig, PTR_UP, psize);
    cpdf_pointer(xorig-r2, yorig, PTR_DOWN, psize);


    cpdf_finalizeAll();			/* PDF file/memstream is actually written here */
    cpdf_savePDFmemoryStreamToFile("filltest.pdf");

    /* == Clean up == */
    cpdf_close();			/* shut down */
    cpdf_launchPreview();		/* launch Acrobat/PDF viewer on the output file */
}

