/* cpdfDomPlot.c  -- plotting functions in raw domain of points
 * Copyright (C) 1998 FastIO Systems, All Rights Reserved.
 * For conditions of use, license, and distribution, see LICENSE.txt or LICENSE.pdf.

1998-07-09 [IO]
*/

#include "version.h"

#include <string.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include "cpdflib.h"		/* This must be included before all other local include files */
#include "cglobals.h"

void cpdf_moveto(float x, float y)
{
	cpdf_rawMoveto(x_Domain2Points(x), y_Domain2Points(y));
}

void cpdf_lineto(float x, float y)
{
	cpdf_rawLineto(x_Domain2Points(x), y_Domain2Points(y));
}

void cpdf_rmoveto(float x, float y)
{
	cpdf_rawRmoveto(x_Domain2Points(x), y_Domain2Points(y));
}

void cpdf_rlineto(float x, float y)
{
	cpdf_rawRlineto(x_Domain2Points(x), y_Domain2Points(y));
}

void cpdf_curveto(float x1, float y1, float x2, float y2, float x3, float y3)
{
	cpdf_rawCurveto(x_Domain2Points(x1), y_Domain2Points(y1),
			x_Domain2Points(x2), y_Domain2Points(y2),
			x_Domain2Points(x3), y_Domain2Points(y3));
}

void cpdf_quickCircle(float x, float y, float r)	/* center (x,y) and radius r */
{
float convr;
	convr = x_Domain2Points(x+r) - x_Domain2Points(x);
	cpdf_rawQuickCircle(x_Domain2Points(x), y_Domain2Points(y), convr);
}

void cpdf_rect(float x, float y, float w, float h)
{
float convw, convh;
	convw = x_Domain2Points(x+w) - x_Domain2Points(x);
	convh = y_Domain2Points(y+h) - y_Domain2Points(y);
	cpdf_rawRect(x_Domain2Points(x), y_Domain2Points(y), convw, convh);
}


