/* cpdfImgIL.c  -- In-line image functions.
 * Copyright (C) 1998 FastIO Systems, All Rights Reserved.
 * For conditions of use, license, and distribution, see LICENSE.txt or LICENSE.pdf.

	Image data are written to the page content stream without using the XObject.
	Only for small images.

1998-09-27 [IO]
*/

/* #define DEBUG 1 */

#include "version.h"

#include <string.h>
#include <math.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>

#include "cpdflib.h"		/* This must be included before all other local include files */
#include "cglobals.h"

int cpdf_placeInLineImage(void *imagedata, int len,
		float x, float y, float angle, float width, float height,
		int pixwidth, int pixheight, int bitspercomp, int CSorMask, int gsave)
{
    cpdf_rawPlaceInLineImage(imagedata, len,
		x_Domain2Points(x), y_Domain2Points(y), angle, width, height,
		pixwidth, pixheight, bitspercomp, CSorMask, gsave);
    return(0);
}

int cpdf_rawPlaceInLineImage(void *imagedata, int len,
		float x, float y, float angle, float width, float height,
		int pixwidth, int pixheight, int bitspercomp, int CSorMask, int gsave)
{
int count, bufsize;
char *mbuff;

    if(gsave) cpdf_gsave();
    cpdf_rawTranslate(x, y);
    if(fabs(angle) > 0.001)
	cpdf_rotate(angle);
    cpdf_rawConcat(width, 0.0, 0.0, height, 0.0, 0.0);	/* concatename CTM */

    cpdf_clearMemoryStream(scratchMem);
    inlineImages++;				/* For enabling Image* ProcSet */
    cpdf_memPuts("BI\n", scratchMem);		/* begin image */

    sprintf(spbuf, "/W %d\n/H %d\n/BPC %d\n", pixwidth, pixheight, bitspercomp);
    cpdf_writeMemoryStream(scratchMem, spbuf, strlen(spbuf));

    switch(CSorMask & 3) {
	    case IMAGE_MASK:
			cpdf_memPuts("/ImageMask true\n", scratchMem);
	    		imageFlagBCI |= 4;		/* /ImageI procset */
			break;
	    case CS_GRAY:
	    		imageFlagBCI |= 1;		/* /ImageB procset */
			cpdf_memPuts("/ColorSpace /DeviceGray\n", scratchMem);
			break;
	    case CS_RGB:
			cpdf_memPuts("/ColorSpace /DeviceRGB\n", scratchMem);
	    		imageFlagBCI |= 2;		/* /ImageC procset */
			break;
	    case CS_CMYK:
			cpdf_memPuts("/ColorSpace /DeviceCMYK\n", scratchMem);
	    		imageFlagBCI |= 2;		/* /ImageC procset */
			break;
    }
    cpdf_memPuts("ID ", scratchMem);		/* the space char after ID is important */
    /* OK, here we dump the data in binary.  No need to do any compression
	because the page content stream itself is compressed by Flate
	compression anyway (if it is enabled).
    */
    cpdf_writeMemoryStream(scratchMem, imagedata, len);

    cpdf_memPuts("\nEI\n", scratchMem);		/* end image */

    cpdf_getMemoryBuffer(scratchMem, &mbuff, &count, &bufsize);
    if(useContentMemStream)
	cpdf_writeMemoryStream(currentMemStream, mbuff, count);
    else
	fwrite(mbuff, 1, (size_t)count, fpcontent);

    if(gsave) cpdf_grestore();

    return(0);
}
