#import "Controller.h"
#import "DAImageBrowser.h"
#import "DAAbout.h"
#import "DAPreferences.h"

@implementation Controller

- (void)applicationDidFinishLaunching:(NSNotification *)notification;
{
    NSDictionary	*filterTypes = [[NSUserDefaults standardUserDefaults] dictionaryForKey:FilterForExtensionsDefault];
    if ( filterTypes == nil )
    {
        NSArray	*keys = [NSArray arrayWithObjects:@"tiff", @"gif", @"jpg", nil];
        NSArray	*objects = [NSArray arrayWithObjects:@"Tagged Image File Format", @"Graphics Interchange Format", @"You know .. J-PEG", nil];

        NSDictionary *types = [NSDictionary dictionaryWithObjects:objects forKeys:keys];
        NSDictionary *defaults = [NSDictionary dictionaryWithObject:types forKey:FilterForExtensionsDefault];


        [[NSUserDefaults standardUserDefaults] registerDefaults:defaults];
    }

}
- (void)openDirectory:(id)sender
{
    [DAImageBrowser openNewDirectory];
}

- (void)openInfo:(id)sender
{
    [[DAAbout shared] display];
}

- (void)openPreferences:(id)sender
{
    [[DAPreferences shared] display];
}

- (void)browserDirectoryService:(NSPasteboard *)pboard userData:(NSString *)data error:(NSString **)error
{
    NSArray	*types = [pboard types];

    NSLog( @"Perfoming service" );
    if ( [types containsObject:NSFilenamesPboardType])
    {
   	NSArray	*filesArray = [pboard propertyListForType:NSFilenamesPboardType];

        NSLog( @"     %@", filesArray );

        if ( [filesArray count] > 0 )
        {
            NSEnumerator *fileEnum = [filesArray objectEnumerator];
            NSString	*file = nil;

            while ( file = [fileEnum nextObject] )
            {
                DAImageBrowser *browser = [[DAImageBrowser allocDocumentZone:@"DAImageBrowserService"] init];

                [browser setRoot:file];
                [browser display];
                NSLog( @"     opened file %@", file );
            }
        }
        else
        {
            *error = @"No selected directories";
        }
    }
    else
    {
    	/*
		*error = NSLocalizedString(@"Error: Pasteboard doesn't contain a string.", @"Pasteboard couldn't give string.");
	*/
        *error = @"Could not determine directory to browse";
    }
    return;
}

@end
