#import "DASubController.h"

@implementation DASubController

+ (id)shared
{
    NSLog( @"Error: (+ shared) %@ %@\n", @"Subclasses of DASubController must implement their own shared object strategy\nCould not allocate shared instance of class", NSStringFromClass([self class]) );
    return [self new];
}

+ new
{
    return [[[self allocDocumentZone:NSStringFromClass([self class])] init] autorelease];
}

+ allocDocumentZone:(NSString *)name
{
    NSZone	*zone = NSCreateZone(vm_page_size, vm_page_size, YES);
    if ( zone && name )
        NSSetZoneName( zone, name);
    return [self allocWithZone:zone];
}

- (id)init
{
    if ( [super init] )
    {
        if ( [NSBundle loadNibNamed:NSStringFromClass([self class]) owner:self] == NO )
        {
                [self autorelease];
                self = nil;
        }
    }
    return self;
}

- (void)awakeFromNib;
{
    [window setDelegate:self];
    [window setFrameAutosaveName:NSStringFromClass([self class])];
}

- (void)dealloc
{
    NSLog( @"dealloc subcontroller" );
    [[self window] setDelegate:nil];
    [super dealloc];
}

- (void)display
{
    [self display:self];
}

- (void)display:sender
{
    [window makeKeyAndOrderFront:sender];
}

- window
{
    return window;
}

// should cover window delegate methods as an example to subclasses

@end
