#import "FilteredFileInfo.h"

NSString *FilterForExtensionsDefault = @"FilterForExtensions";

@implementation FilteredFileInfo

-(id) initWithPath:(NSString *) path
{
    BOOL success = NO;

    self = [super initWithPath:path];
    parent = nil;
    
    if (filetype != NSFileTypeDirectory)
    {
        NSDictionary	*filterDict = [[NSUserDefaults standardUserDefaults] dictionaryForKey:FilterForExtensionsDefault];

        if ( filterDict && ([filterDict count] > 0 ))
        {
            NSArray	*filterTypes = [filterDict allKeys];
            NSEnumerator *typeEnum = [filterTypes objectEnumerator];
            NSString *aFilter = nil;

            while ((aFilter = [typeEnum nextObject]) && (success == NO))
            {
                NSRange	range = {[filename length] - [aFilter length], [aFilter length]};

                success = ([filename compare:aFilter options:NSCaseInsensitiveSearch range:range] == NSOrderedSame);
            }
        }
        else
            success = YES;
    }
    else
        success = YES;;

    if ( success == NO )
    {
        [self release];
        self = nil;
    }
    
    return self;
}

- (void)setParent:(FilteredFileInfo *)value
{
    [parent autorelease];
    parent = [value retain];
}
- (FilteredFileInfo *)parent
{
    return parent;
}

- (BOOL)delete
{
    [filename autorelease];
    [filetype autorelease];
    [lastModified autorelease];
    [fullPathName autorelease];
    
    if ( containedFiles )
        [containedFiles makeObjectsPerformSelector:@selector(delete)];

    filename = @"Deleted";
    filetype = @"none";
    lastModified = nil;
    fullPathName = @"Deleted";

    return YES;
}

- (void)setContainedFiles:(NSArray *)value;
{
    [super setContainedFiles:value];
    if ( containedFiles )
        [containedFiles makeObjectsPerformSelector:@selector(setParent:) withObject:self];
}

@end