
/*
    File:       FinderListModeController.h

    Contains:   Interface for FinderListModeController, a datasource for an
                NSOutlineView object that interfaces with FileInfo objects to
                provide information about the directory structure of the user's
                file system.  Information is displayed by a NSOutlineView in a
                manner similar to the List View in the Macintosh Finder.

    Written by: Andy Wildenberg

    Created:    9 July 1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History:
       version 1.0: first public version

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DTS Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import <AppKit/AppKit.h>

#import "FileInfo.h"

@interface FinderListModeController : NSObject
{
    id finderListWindow;  // to set the title
    NSString *currentPath;

    FileInfo* topFileInfo; // thie FileInfo stores information about the root directory
}

// routines for the outline view
- (id)outlineView:(NSOutlineView *)outlineView child:(int)index ofItem:(id)item;
- (BOOL)outlineView:(NSOutlineView *)outlineView isItemExpandable: (id)item;
- (int)outlineView:(NSOutlineView *)outlineView numberOfChildrenOfItem:(id)item;
- (id)outlineView:(NSOutlineView *)outlineView objectValueForTableColumn:(NSTableColumn *)tableColumn byItem:(id)item;

- (void)createTopFileInfo:(NSString*)topPath; // create a new controller with topPath as its top-most directory

// setup is performed here
- (id)init;
- (void)awakeFromNib;

// window delegate method we use to quit the application when the window is closed.
- (BOOL)windowShouldClose:(id)sender;

// cleanup is performed here
- (void)dealloc;
@end
