#import "NSImage+SNExtensions.h"

@implementation NSImage (SNExtensions)

+ (NSImage *) imageNamed:(NSString *)imageName fromBundle:(NSBundle *)bundle
{
    NSImage *image;
    NSString *imagePath;

    imagePath = [bundle pathForImageResource:imageName];
    NSAssert1 (imagePath != nil, @"Could not find image: '%@'", imageName);

    image = [[NSImage alloc] initByReferencingFile:imagePath];
    NSAssert1 (image != nil, @"Couldn't load image: '%@'", imageName);

    return [image autorelease];
}

@end
