//
//  This file is a part of StevesClock.app, a simple dock clock application.
//  Copyright (C) 1998  Steve Nygard
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//  You may contact the author by:
//     e-mail:  nygard@telusplanet.net
//

#import <AppKit/AppKit.h>

@interface SNClockView : NSView
{
    NSCalendarDate *date;

    BOOL militaryTime;
    NSTimer *timer;
}

+ (void) initialize;
+ (void) loadClassImages;

- initWithFrame:(NSRect)frameRect;
- (void) dealloc;

- (NSCalendarDate *) date;
- (void) setDate:(NSCalendarDate *)newDate;

- (BOOL) militaryTime;
- (void) setMilitaryTime:(BOOL)flag;

- (void) showCurrentTime;
- (void) updateCurrentTime:(NSTimer *)userInfo;

- (void) drawRect:(NSRect)rect;

@end
