#import "Provider.h"
#import <unistd.h>		// system calls
#import <fcntl.h>		// open
#import <sys/types.h>		// wait
#import <sys/wait.h>

@implementation NSObject (Provider)

- (void)filter:(NSPasteboard*)pboard
        userData:(NSString*)data error:(NSString**)error {
  NSAutoreleasePool * pool = [NSAutoreleasePool new];

  NSString *fnm = [[pboard propertyListForType:[[pboard types] objectAtIndex:0]]
			objectAtIndex:0];
  const char *cmd = [[NSString stringWithFormat:data,
			[NSString stringWithFormat:@"'%@'", fnm]] cString];
  int out[2], err[2], pid, status;
  NSData * output, * diagnostic;

  if (pipe(out) == -1 || pipe(err) == -1 || (pid = fork()) == -1) {
    NSLog(@"pipe or fork: %s", strerror(errno));
    *error = @"cannot run converter";
    close(out[0]); close(out[1]); close(err[0]); close(err[1]);

  } else if (pid == 0) {	// son: runs conversion script

    close(out[0]); close(err[0]);
    close(0); if (open("/dev/null", 0) != 0) NSLog(@"open null err");
    close(1); if (dup(out[1]) != 1) NSLog(@"dup out err");
    close(2); if (dup(err[1]) != 2) NSLog(@"dup err err");
    close(out[1]); close(err[1]);
    execl("/bin/sh", "sh", "-c", cmd, (char*)0);
    NSLog(@"exec err: %s", strerror(errno)); _exit(127);

  } else {			// father: retrieves and posts output

    NSFileHandle		// this can block on large diagnostic
      *o = [[NSFileHandle alloc] initWithFileDescriptor:out[0]],
      *e = [[NSFileHandle alloc] initWithFileDescriptor:err[0]];
    close(out[1]); close(err[1]);
    output = [o readDataToEndOfFile]; [o release]; close(out[0]);
    diagnostic = [e readDataToEndOfFile]; [e release]; close(err[0]);

    while (wait(&status) != pid)
      ;
    if (status != 0) NSLog(@"exit %d error", status);

    if ([diagnostic length] != 0)
      NSLog(@"%.*s", [diagnostic length], [diagnostic bytes]);

    [pboard declareTypes:[NSArray arrayWithObject:NSTIFFPboardType] owner:nil];
    [pboard setData:output forType:NSTIFFPboardType];
  }
  [pool release];
}
@end
