/*

 MiscSoundViewInspector
 Version 2.0
 Copyright (c) 1995 by Sean Luke
 OpenStep / Rhapsody port
 Copyright (c) 1998 by Jerome Genest
 Donated to the MiscKit

 Permission to use, copy, modify, and distribute this material
 for any purpose and without fee, under the restrictions as noted
 in the MiscKit copyright notice, is hereby granted, provided that
 the MiscKit copyright notice and this permission notice
 appear in all source copies, and that the authors names shall not
 be used in advertising or publicity pertaining to this
 material without the specific, prior written permission
 of the author.  SEAN O. LUKE AMD JEROME GENEST  MAKE NO REPRESENTATIONS
 ABOUT THE ACCURACY OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.
 IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.

 */

#import <MiscSoundKit/MiscSoundView.h>
#import "MiscSoundViewInspector.h"

@implementation MiscSoundViewInspector

- init
	{
	NSString * buf;
	id bundle;
	
	[super init];
	bundle=[NSBundle bundleForClass:[self class]];
	buf = [bundle pathForResource:@"MiscSoundViewInspector" ofType:@"nib"];
	[NSBundle loadNibFile:buf externalNameTable:[NSDictionary dictionaryWithObjectsAndKeys:self, @"NSOwner", nil] withZone:[self zone]];
        //printf([buf cString]);
	return self;
	}
	

-(void) ok:sender
	{
	float mi=[minor floatValue];
	int ma=[major intValue];
	int rul;
	int lab;
	int y;
	int z;
	int unit;
	int line;
	int scro;
	id object = [self object];
	if ([lines selectedRow])
		{if ([lines selectedColumn]) 
			line=MISCSOUNDVIEW_YAXIS_DISPLAY_FORMAT_DECIBEL;
		 else line=MISCSOUNDVIEW_YAXIS_DISPLAY_FORMAT_TWENTY;}
	else
		{if ([lines selectedColumn])
			line=MISCSOUNDVIEW_YAXIS_DISPLAY_FORMAT_TWENTYFOUR;
		 else line=MISCSOUNDVIEW_YAXIS_DISPLAY_FORMAT_SIXTEEN;}
		 
	scro=[scroll intValue];
	rul=[[display cellAtRow:0 column:0] intValue];
	lab=[[display cellAtRow:1 column:0] intValue];
	y=[[display cellAtRow:0 column:1] intValue];
	z=[[display cellAtRow:1 column:1] intValue];
	
	if ([units selectedRow]==0) 
		unit=MISCSOUNDVIEW_XAXIS_SPACING_FORMAT_SAMPLES;
	else if ([units selectedRow]==1) 
		unit=MISCSOUNDVIEW_XAXIS_SPACING_FORMAT_SECONDS;
	else unit=MISCSOUNDVIEW_XAXIS_SPACING_FORMAT_PERCENT;
		 
	if (mi<=0.0){mi=1000.0;[minor setFloatValue:mi];}
	if (ma<=0){ma=10;[major setIntValue:ma];}
	
	[object set:rul:y:lab:z:ma:mi:unit:line:scro];

	return [super ok:sender];
	}
	
- (void)revert:sender
	{
	id object = [self object];
	int line=[object yDisplayFormat];
	int unit=[object minorTickSpacingFormat];
	
	[scroll setIntValue:[object scrollToReflectPlaying]];
	[major setIntValue:[object majorTickSpacing]];
	[minor setFloatValue:[object minorTickSpacing]];
	[[display cellAtRow:0 column:0] setIntValue:[object xAxisDisplayed]];
	[[display cellAtRow:1 column:0] setIntValue:[object labelsDisplayed]];
	[[display cellAtRow:0 column:1] setIntValue:[object yAxisDisplayed]];
	[[display cellAtRow:1 column:1] setIntValue:[object zeroLineDisplayed]];
	
	if (unit==MISCSOUNDVIEW_XAXIS_SPACING_FORMAT_SAMPLES)
		[units selectCellAtRow:0 column:0];
	else if (unit==MISCSOUNDVIEW_XAXIS_SPACING_FORMAT_SECONDS)
		[units selectCellAtRow:1 column:0];
	else [units selectCellAtRow:2 column:0];
	
	if (line==MISCSOUNDVIEW_YAXIS_DISPLAY_FORMAT_SIXTEEN)
		[lines selectCellAtRow:0 column:0];
	else if (line==MISCSOUNDVIEW_YAXIS_DISPLAY_FORMAT_TWENTY)
		[lines selectCellAtRow:1 column:0];
	else if (line==MISCSOUNDVIEW_YAXIS_DISPLAY_FORMAT_TWENTYFOUR)
		[lines selectCellAtRow:0 column:1];
	else [lines selectCellAtRow:1 column:1];
		
	return [super revert:sender];
	}
	
- (BOOL) wantsButtons
	{
	return NO;
	}

@end
