#import <AppKit/NSImage.h>
#import "ico.h"
#import "Bitmap.bproj/ColorMap.h"

@class	NSArray, NSString;

@interface IcoImage : NSImage
{
	NSSize		size;
	int		colors;
	commonInfo	info;
	ColorMap	*cmap;
	paltype		*palette;
	unsigned char	*map;
	unsigned char	*alp;
	unsigned char	*planes[MAXPLANE];
}

+ (NSArray *)imagesWithContentsOfFile:(NSString *)path;
+ (BOOL)saveImages:(NSArray *)images as:(NSString *)path;

- (id)init;
- (void)dealloc;
- (int)colors;

/* Over Write */
- (NSSize)size;

/* for non-ICO file */
- (commonInfo *)getImageInfo;
- (int)numberOfColors;
- (void)makeUpIcoImage:(int)cnum;

- (void)makeUpIcoRep;

@end

