#import "IcoMakerCtrl.h"
#import <Foundation/NSArray.h>
#import <Foundation/NSBundle.h>	/* LocalizedString */
#import <AppKit/NSWindow.h>
#import <AppKit/NSOpenPanel.h>
#import "common.h"
#import "WinControl.h"

static NSString *odir = nil;

@implementation IcoMakerCtrl

- (id)init
{
	[super init];
	mainWinCtrl = nil;
	winset = [[NSMutableArray alloc] initWithCapacity:1];
	return self;
}

- (void)dealloc
{
	[winset release];
	[super dealloc];
}


/* Local Method */
- (id)isOpenedNow:(NSString *)fname
{
	int	i, n;
	id	obj;

	if (winset == nil)
		return nil;
	n = [winset count];
	for (i = 0; i < n; i++) {
		obj = [winset objectAtIndex:i];
		if ([[obj filename] isEqualToString:fname])
			return obj;
	}
	return nil;
}

/* Local Method */
- (BOOL)openWithPath:(NSString *)fname
{
	NSString *msg;
	id	already;
	id	newwin;

	if (![[fname pathExtension] isEqualToString:EXTENSION]) {
		msg = NSLocalizedString(@"Illegal file type", Err_Type);
		NSRunAlertPanel(NSLocalizedString(@"Error", Error),
			@"%@ :\n%@", @"", nil, nil, msg, fname);
		return NO;
	}
	if ((already = [self isOpenedNow: fname]) != nil) {
		[already makeKeyAndOrderFront:self];
		return NO;
	}
	newwin = [[WinControl alloc] initWithController:self];
	if ([newwin openImageFile:fname]) { /* success */
		[winset addObject: newwin];
	}else {
		msg = NSLocalizedString(@"Can not read", Err_Read);
		NSRunAlertPanel(NSLocalizedString(@"Error", Error),
			@"%@ :\n%@", @"", nil, nil, msg, fname);
		[newwin release];
		return NO;
	}
	return YES;
}

- (void)openFile:(id)sender
{
	NSOpenPanel *opp;
	NSString *dr;
	NSArray *farr;
	int	n, i;
	static NSArray	*icoTypes = nil;

	if (icoTypes == nil)
		icoTypes = [[NSArray arrayWithObject:EXTENSION] retain];
	opp = [NSOpenPanel openPanel];
	[opp setTitle:NSLocalizedString(@"Open", OpenDoc)];
	[opp setTreatsFilePackagesAsDirectories:YES];
	[opp setAllowsMultipleSelection:YES];
	if (odir == nil)
		odir = [NSHomeDirectory() copyWithZone:[self zone]];
	if ([opp runModalForDirectory:odir file:nil types:icoTypes] == NSCancelButton)
		return;

	farr = [opp filenames];
	dr = [opp directory];
	if (![odir isEqualToString: dr]) {
		[odir release];
		odir = [dr retain];
	}

	n = [farr count];
	for (i = 0; i < n; i++)
		(void)[self openWithPath: [farr objectAtIndex: i]];
}

- (void)createNewImage:(id)sender
{
	id newwin = [[WinControl alloc] initWithController:self];
	[newwin openNewWindow];
	[winset addObject: newwin];
}

- (void)readImage:(id)sender
{
	NSOpenPanel *opp;
	NSString *dr;
	NSArray *farr;
	static NSMutableArray	*imageTypes = nil;

	if (mainWinCtrl == nil)
		return;
	if (imageTypes == nil) {
		imageTypes = [[NSImage imageFileTypes]
				mutableCopyWithZone:[self zone]];
		[imageTypes removeObject:@"eps"];
		[imageTypes removeObject:@"EPS"];
	}
	opp = [NSOpenPanel openPanel];
	[opp setTitle:NSLocalizedString(@"Include Image", IncludeImage)];
	[opp setTreatsFilePackagesAsDirectories:YES];
	[opp setAllowsMultipleSelection:NO];
	if (odir == nil)
		odir = [NSHomeDirectory() copyWithZone:[self zone]];
	if ([opp runModalForDirectory:odir file:nil types:imageTypes] == NSCancelButton)
		return;

	farr = [opp filenames];
	dr = [opp directory];
	if (![odir isEqualToString: dr]) {
		[odir release];
		odir = [dr retain];
	}

	[mainWinCtrl includeImage:[farr objectAtIndex: 0]];
}

- (void)revert:(id)sender
{
	int	rtn;
	NSString *name;

	if (mainWinCtrl == nil)
		return;
	name = [mainWinCtrl filename];
	if (![name isAbsolutePath]) {
		NSBeep();	/* Untitled */
		return;
	}
	rtn = NSRunAlertPanel(NSLocalizedString(@"Warning", Warning),
		NSLocalizedString(@"Really Reload", ReallyReload),
		NSLocalizedString(@"Do Reload", DoReload),
		NSLocalizedString(@"Cancel", Cancel), nil);
	if (rtn != NSAlertDefaultReturn)
		return;
	[name retain];
	[mainWinCtrl closeAnyway];
	[self openWithPath:name];
	[name release];
}

- (void)saveImage:(id)sender
{
	[mainWinCtrl saveImage:sender];
}

- (void)saveImageAs:(id)sender
{
	[mainWinCtrl saveImageAs:sender];
}

- (void)saveAsTiff:(id)sender
{
	[mainWinCtrl saveAsTiff:sender];
}

/* Based on NSMenuActionResponder's Protocol */
- (BOOL)validateMenuItem:(NSMenuItem *)anItem
{
	if ([anItem tag] == 0)
		return YES;
	return (winset != nil && [winset count] > 0);
}


/* notice from WinControl */
- (void)didBecomeMain:(id)sender
{
	mainWinCtrl = sender;
}

/* notice from WinControl */
- (void)willBeClosed:(id)sender
{
	[winset removeObject:sender];
}


/* App's Delegate */
- (void)applicationDidFinishLaunching:(NSNotification *)notification
{
	id sTypes = [NSArray array];	/* Empty array */
	id rTypes = [NSArray arrayWithObject: NSTIFFPboardType];
	[NSApp registerServicesMenuSendTypes:sTypes returnTypes:rTypes];
}

- (BOOL)application:(NSApplication *)theApplication openFile:(NSString *)filename
{
	if (odir == nil)
		odir = [[filename stringByDeletingLastPathComponent] retain];
	return [self openWithPath:filename];
}

- (BOOL)applicationShouldTerminate:(NSApplication *)sender
{
	int	n;
	id	obj;

	[WinControl setTerminate:YES];
	if (winset == nil)
		return YES;
	n = [winset count];
	for (--n; n >= 0; --n) {
		obj = [winset objectAtIndex:n];
		[obj makeKeyAndOrderFront:self];
		[obj performClose:self];
	}
	return YES;
}


/* To receive services, implement these methods (delegate) */
- validRequestorForSendType:(NSString *)typeSent returnType:(NSString *)typeReturned
{
	return [typeReturned isEqualToString:NSTIFFPboardType] ? self : nil;
}

- (BOOL)readSelectionFromPasteboard:(NSPasteboard *)pb
{
	if (mainWinCtrl == nil) {
		NSBeep();
		return NO;
	}
	[mainWinCtrl includePasteboard: pb];
	return YES;
}

@end
