#import "ImagePanelCtrl.h"
#import <AppKit/NSApplication.h>

@implementation ImagePanelCtrl

- (void)setInfo:(commonInfo *)info name:(NSString *)name colors:(int)cnum andImage:(NSImage *)image
{
	[filenameTX setStringValue:name];
	[sizeTX setStringValue:[NSString stringWithFormat:@"Size: %d x %d",
		info->width, info->height]];
	if (cnum > 256) {
		[colorsTX setStringValue:@"Colors > 256"];
		[okBT setEnabled:NO];
		[rd16BT setEnabled:YES];
		[rd256BT setEnabled:YES];
	}else {
		[colorsTX setStringValue:
			[NSString stringWithFormat:@"Colors = %d", cnum]];
		[okBT setEnabled:YES];
		[rd256BT setEnabled:NO];
		[rd16BT setEnabled:(cnum > 16)];
	}
	[imageView setImage:image];
	[imageView display];
	[panel makeKeyAndOrderFront:self];
	[NSApp runModalForWindow:panel];
}

- (void)buttonPushed:(id)sender
{
	[NSApp stopModal];
	selectedTag = [sender tag];
	[panel close];
}

- (int)selectedTag
{
	return selectedTag;
}

@end
