#import <AppKit/AppKit.h>
#import "common.h"

#define  MiniWinImage	@"icoIcon"

@class NSString, NSImage, NSData, NSPasteboard;

@interface WinControl : NSObject
{
	id	box;
	id	msgText;
	id	window;
	id	controller;
	id	panelctrl;
	NSString *filename;
	id	elements[IcoIMAGES];
}

+ (NSImage *)loadImageOfMiniWin;
+ (void)setTerminate:(BOOL)flag;

- (id)initWithController:(id)obj;
- (void)dealloc;
- (BOOL)openImageFile:(NSString *)name;
- (void)openNewWindow;
- (void)performClose:(id)sender;
- (void)closeAnyway;
- (void)setFilename:(NSString *)name;
- (NSString *)filename;
- (void)includeImage:(NSString *)name;
- (void)includeStream:(NSData *)stream;
- (void)includePasteboard:(NSPasteboard *)pb;
- (void)saveImage:(id)sender;
- (void)saveImageAs:(id)sender;
- (void)saveAsTiff:(id)sender;

- (void)buttonPushed:(id)sender;

- (void)makeKeyAndOrderFront:(id)sender;

/* Window's Delegate */
- (void)windowDidBecomeMain:(NSNotification *)aNotification;
- (BOOL)windowShouldClose:(id)sender;
- (void)paste:(id)sender;

@end
