#import "WinControl.h"
#import <Foundation/NSBundle.h>
#import <Foundation/NSArray.h>
#import <Foundation/NSData.h>
#import <AppKit/NSWindow.h>
#import <AppKit/NSSavePanel.h>
#import <Foundation/NSFileManager.h>
#import "common.h"
#import "IcoMakerCtrl.h"
#import "ElementControl.h"
#import "IcoImage.h"
#import "ImagePanelCtrl.h"
#import "TiffSavePanel.h"

#define  DIFF	20

static BOOL termMode = NO;
static NSString	*odir = nil;


@implementation WinControl

+ (NSImage *)loadImageOfMiniWin
{
	NSString *fname;
	static NSImage *mini = nil;

	if (mini)
		return mini;
	fname = [[NSBundle mainBundle]
			pathForResource:MiniWinImage ofType:@"tiff"];
	if (fname)
		mini = [[NSImage alloc] initWithContentsOfFile:fname];
	return mini;
}

+ (void)setTerminate:(BOOL)flag
{
	termMode = flag;
}


/* Local Method */
- (void)loadNib
{
	id	cview;
	NSPoint	pnt;
	NSSize	sz, boxsz, boxmgn;
	NSRect	winframe;
	int	i, j;
	static int winsn = 0;

	if (window != nil)
		return;
	[NSBundle loadNibNamed:@"ImageWin.nib" owner:self];
	// [window setDelegate:self];
	// [window setFrameUsingName: InspectorPanelName];
	elements[0] = [[ElementControl alloc] init];
	cview = [elements[0] loadInterface:self];
	/* resize window to (IcoIMAGES / 2) lines and 2 rows of cview */
	winframe = [window frame];
	boxsz = [box frame].size;
	boxmgn = [box contentViewMargins];
	boxsz.height -= (boxmgn.height + 2) * 2;
	boxsz.width -= (boxmgn.width + 2) * 2;
	sz = [cview frame].size;
	winframe.size.height += sz.height * (IcoIMAGES / 2) - boxsz.height;
	winframe.size.width += sz.width * 2 - boxsz.width;
	winframe.origin.x += (winsn % 4) * DIFF;
	winframe.origin.y -= (winsn % 5) * DIFF;
	winsn++;
	[window setFrame:winframe display:NO];

	[elements[0] setImageSize:16];
	[elements[0] setColors:16];
	[box addSubview: cview];
	pnt.x = 0.0;
	pnt.y = sz.height * (IcoIMAGES / 2 - 1);
	[cview setFrameOrigin:pnt];
	for (i = 1, j = 2; i < (IcoIMAGES / 2); i++, j++) {
		elements[i] = [[ElementControl alloc] init];
		cview = [elements[i] loadInterface:self];
		[box addSubview: cview];
		pnt.y = sz.height * (IcoIMAGES / 2 - 1 - i);
		[cview setFrameOrigin:pnt];
		[elements[i] setImageSize: 16 * j];
		[elements[i] setColors:16];
	}
	pnt.x = sz.width;
	for (i = (IcoIMAGES / 2), j = 1; i < IcoIMAGES; i++, j++) {
		elements[i] = [[ElementControl alloc] init];
		cview = [elements[i] loadInterface:self];
		[box addSubview: cview];
		pnt.y = sz.height * (IcoIMAGES - 1 - i);
		[cview setFrameOrigin:pnt];
		[elements[i] setImageSize: 16 * j];
		[elements[i] setColors:256];
	}
}

- (id)initWithController:(id)obj
{
	int	i;

	[super init];
	filename = nil;
	controller = obj;
	for (i = 0; i < IcoIMAGES; i++)
		elements[i] = nil;
	return self;
}

- (void)dealloc
{
	int	i;

	[filename release];
	for (i = 0; i < IcoIMAGES; i++)
		[elements[i] release];
	[super dealloc];
}

/* Local Method */
- (int)showCountMessage
{
	int	i, cnt;
	NSString *msg;

	cnt = 0;
	for (i = 0; i < IcoIMAGES; i++)
		if ([elements[i] state])
			cnt++;
	if (cnt == 1)
		[msgText setStringValue:
			NSLocalizedString(@"1 image", OneImage)];
	else if (cnt > 1) {
		msg = NSLocalizedString(@"%d images", SomeImages);
		[msgText setStringValue: [NSString stringWithFormat:msg, cnt]];
	}else {
		[msgText setStringValue:
			NSLocalizedString(@"No image", NoImage)];
	}
	return cnt;
}

/* Local Method */
- (int)indexOfElementWith:(int)size and:(int)col
{
	int	i, s, clr;

	for (i = 0; i < IcoIMAGES; i++) {
		s = [elements[i] imageSize];
		clr = [elements[i] colors];
		if (size == s && col == clr)
			return i;
	}
	return -1;
}

- (BOOL)openImageFile:(NSString *)name
{
	id	arr;
	int	i, j, n;

	if ((arr = [IcoImage imagesWithContentsOfFile:name]) == nil)
		return NO;

	[self loadNib];
	[self setFilename:name];
	[window makeKeyAndOrderFront:self];

	n = [arr count];
	for (j = 0; j < n; j++) {
		id	obj = [arr objectAtIndex:j];
		i = [self indexOfElementWith:[obj size].width and:[obj colors]];
		if (i >= 0)
			[elements[i] setImage:obj];
	}
	(void)[self showCountMessage];
	[window setMiniwindowImage:[arr objectAtIndex:(n-1)]];
	return YES;
}

- (void)openNewWindow
{
	id	mini;
	NSString	*tmpname;
	static int	tmpserial = 0;

	[self loadNib];
	tmpname = [NSString stringWithFormat:@"%@%d.%@",
			NSLocalizedString(@"Untitled", Untitled),
			++tmpserial, EXTENSION];
	[self setFilename:tmpname];
	[window makeKeyAndOrderFront:self];
	(void)[self showCountMessage];
	if ((mini = [[self class] loadImageOfMiniWin]) != nil)
		[window setMiniwindowImage:mini];
}

- (void)performClose:(id)sender
{
	[window performClose:sender];
}

- (void)closeAnyway
{
	[window setDocumentEdited:NO];
	[window performClose:self];
	/* Don't use 'close'.  We must use delegate method of the window */
}

- (void)setFilename:(NSString *)name
{
	[filename release];
	filename = name;
	[filename retain];
	if (window != nil) {
		if ([filename isAbsolutePath])
			[window setTitleWithRepresentedFilename:filename];
		else
			[window setTitle:filename];
	}
}

- (NSString *)filename
{
	return filename;
}

/* Local Method */
- (BOOL)includeIco:(IcoImage *)ico name:(NSString *)name
{
	int	i, n, cnum, rd;
	NSString *msg;
	commonInfo *info;

	if ((info = [ico getImageInfo]) == NULL) {
		msg = NSLocalizedString(@"Can not read EPS files", Err_ReadEPS);
		NSRunAlertPanel(NSLocalizedString(@"Error", Error),
			@"%@ :\n%@", @"", nil, nil, msg, name);
		return NO;
	}
	if (info->width != info->height || (info->width & 0x0f)
			|| (n = (info->width >> 4)) < 1 || n > 3) {
		msg = NSLocalizedString(@"Illegal Image Size", Err_Size);
		NSRunAlertPanel(NSLocalizedString(@"Error", Error),
		@"%@ (%d x %d)", @"", nil,nil, msg, info->width, info->height);
		return NO;
	}

	cnum = [ico numberOfColors];
	[panelctrl setInfo:info name:name colors:cnum andImage:ico];
	/* Modal Panel will be displayed here ! */
	rd = [panelctrl selectedTag];
	if (rd == RD_CANCEL)
		return NO;
	n = (rd == RD_NONE) ? 0 : ((rd == RD_16) ? 16 : 256);
	[ico makeUpIcoImage:n];
	i = [self indexOfElementWith:info->width and:[ico colors]];
	if (i < 0)
		return NO;	/* Error */
	[elements[i] setImage:ico];
	(void)[self showCountMessage];
	[window setDocumentEdited:YES];
	[window display];

	return YES;
}

- (void)includeImage:(NSString *)name
{
	IcoImage *ico;
	NSString *msg;

	ico = [IcoImage alloc];
	if ([ico initWithContentsOfFile:name] == nil) {
		msg = NSLocalizedString(@"Can not read", Err_Read);
		[ico release];
		NSRunAlertPanel(NSLocalizedString(@"Error", Error),
			@"%@ :\n%@", @"", nil, nil, msg, name);
		return;
	}
	if ([self includeIco:ico name:name] == NO)
		[ico release];
}

- (void)includeStream:(NSData *)stream
{
	IcoImage *ico;
	NSString *msg;

	ico = [IcoImage alloc];
	if ([ico initWithData:stream] == nil) {
		msg = NSLocalizedString(@"Can not read Pasteboard", Err_PB);
		[ico release];
		NSRunAlertPanel(NSLocalizedString(@"Error", Error),
			msg, @"", nil, nil);
		return;
	}
	if ([self includeIco:ico name:@"Pasteboard"] == NO)
		[ico release];
}

- (void)includePasteboard:(NSPasteboard *)pb
{
	NSArray	*pbtypes;
	int	i, count;
	NSString	*typ = nil;

	pbtypes = [pb types];
	count = [pbtypes count];
	for (i = 0; i < count; i++) {
		typ = [pbtypes objectAtIndex: i];
		if ([typ isEqualToString: NSTIFFPboardType])
			break;
	}
	if (i >= count) {
		NSBeep();
		return;
	}
	[self includeStream:[pb dataForType:typ]];
}

/* Local Method */
- (BOOL)checkCount
{
	if ([self showCountMessage] > 0)
		return YES;
	NSRunAlertPanel(NSLocalizedString(@"Error", Error),
		NSLocalizedString(@"No image is selected", Err_Select),
		@"", nil, nil);
	return NO;	
}

/* Local Method */
- (int)saveImageWithName:(NSString *)name
{
	int	i;
	NSMutableArray *imgs;
	NSString *msg;
	NSFileManager *manager = [NSFileManager defaultManager];

	if ([manager fileExistsAtPath:name]) {
		if ([manager removeFileAtPath:name handler:nil] == NO) {
			msg = NSLocalizedString(@"Can not replace", Err_Replace);
			NSRunAlertPanel(NSLocalizedString(@"Error", Error),
				@"%@:\n%@", @"", nil, nil, msg, name);
			return -1;
		}
	}

	imgs = [NSMutableArray arrayWithCapacity:1];
	for (i = 0; i < IcoIMAGES; i++)
		if ([elements[i] state])
			[imgs addObject:[elements[i] image]];
	if ([IcoImage saveImages:imgs as:name] == NO) {
		msg = NSLocalizedString(@"Can not create file", Err_CreateFile);
		NSRunAlertPanel(NSLocalizedString(@"Error", Error),
			@"%@:\n%@", @"", nil, nil, msg, name);
		return -2;
	}
	[window setDocumentEdited:NO];
	return 0;
}

- (void)saveImage:(id)sender
{
	if (![filename isAbsolutePath]) {  /* untitled */
		[self saveImageAs:sender];
		return;
	}
	if (![self checkCount])
		return;
	(void)[self saveImageWithName:filename];
}

- (void)saveImageAs:(id)sender
{
	NSSavePanel *svp;
	NSString *newfn, *dr;

	if (![self checkCount])
		return;
	svp = [NSSavePanel savePanel];
	if ([filename isAbsolutePath])
		[svp setTitle:NSLocalizedString(@"Save As...", Save_Doc_As)];
	else /* untitled */
		[svp setTitle:NSLocalizedString(@"Save", Save)];
	[svp setRequiredFileType:EXTENSION];
	[svp setTreatsFilePackagesAsDirectories:YES];
	if (odir == nil)
		odir = [NSHomeDirectory() copyWithZone:[self zone]];
	if ([svp runModalForDirectory:odir file:[filename lastPathComponent]]
		== NSCancelButton)
		return;

	newfn = [svp filename];
	dr = [svp directory];
	if (![odir isEqualToString: dr]) {
		[odir release];
		odir = [dr retain];
	}

	if ([self saveImageWithName:newfn] == 0)
		[self setFilename:newfn];
}

- (void)saveAsTiff:(id)sender
{
	id	svp;
	NSString *newfn, *dr, *msg;
	int	i, n;
	BOOL	barray[IcoIMAGES];
	NSData	*data;

	for (i = 0, n = 0; i < IcoIMAGES; i++)
		if ([elements[i] image] != nil) {
			barray[i] = YES;
			n++;
		}else
			barray[i] = NO;
	if (n == 0) {
		NSBeep();
		return;
	}

	svp = [TiffSavePanel savePanel];
	[svp setWithBoolArray:barray];
	[svp setTitle:NSLocalizedString(@"Save As TIFF", Save_As_TIFF)];
	[svp setRequiredFileType:@"tiff"];
	[svp setTreatsFilePackagesAsDirectories:YES];
	if (odir == nil)
		odir = [NSHomeDirectory() copyWithZone:[self zone]];
	newfn = [[[filename lastPathComponent] stringByDeletingPathExtension]
		stringByAppendingPathExtension:@"tiff"];
	if ([svp runModalForDirectory:odir file:newfn] == NSCancelButton)
		return;

	newfn = [svp filename];
	dr = [svp directory];
	if (![odir isEqualToString: dr]) {
		[odir release];
		odir = [dr retain];
	}
	i = [svp selectedTag];

	data = [[elements[i] image] TIFFRepresentation];
	if ([data writeToFile:newfn atomically:NO] == NO) {
		msg = NSLocalizedString(@"Can not create file", Err_CreateFile);
		NSRunAlertPanel(NSLocalizedString(@"Error", Error),
			@"%@:\n%@", @"", nil, nil, msg, newfn);
	}
}

- (void)buttonPushed:(id)sender
{
	[window setDocumentEdited:YES];
	(void)[self showCountMessage];
}

- (void)makeKeyAndOrderFront:(id)sender
{
	[window makeKeyAndOrderFront:sender];
}


/* Window's Delegate */
- (void)windowDidBecomeMain:(NSNotification *)aNotification
{
	[controller didBecomeMain:self];
}

/* Window's Delegate */
- (BOOL)windowShouldClose:(id)sender
{
	int	rtn;
	NSString *cancel;

	if ([window isDocumentEdited] && [self showCountMessage] > 0) {
		cancel = termMode ? nil : NSLocalizedString(@"Cancel", Cancel);
		rtn = NSRunAlertPanel(NSLocalizedString(@"Warning", Warning),
			NSLocalizedString(@"Save changes to %@ ?", SaveChanges),
			NSLocalizedString(@"Save", Save),
			NSLocalizedString(@"Don't Save", NotSave),
			cancel, filename);
		if (rtn == NSAlertOtherReturn)
			return NO;	/* Cancel */
		if (rtn == NSAlertDefaultReturn) { /* Save */
			[odir release];
			odir = [filename stringByDeletingLastPathComponent];
			[odir retain];
			[self saveImageAs:self];
		}
	}
	[controller willBeClosed:self];
	[window setDelegate:nil];
	[self release];
	return YES;
}

- (void)paste:(id)sender
{
	[self includePasteboard: [NSPasteboard generalPasteboard]];
	// don't free pasteboard
}

@end
