/* Common Information */
#ifndef _COMMON_h_
#define _COMMON_h_

#define  EXTENSION	@"ico"
#define  IcoIMAGES	6	/* 8, if 64x64 is needed */

#define  Err_OPEN	1
#define  Err_FORMAT	2
#define  Err_MEMORY	3
#define  Err_SHORT	4
#define  Err_ILLG	5
#define  Err_IMPLEMENT	6
#define  Err_SAVE	7
#define  Err_SAV_IMPL	8
#define  Err_EPS_IMPL	9
#define  Err_EPS_ONLY	10
#define  Err_OPR_IMPL	11
#define  Err_NOFILE	12
#define  Err_FLT_EXEC	13

#define  RED	0
#define  GREEN	1
#define  BLUE	2
#define  ALPHA	3
#define  FIXcount	256
#define  MAXWidth	4096	/* Max width of image */
#define  MAXIcoImages	8
#define  MAPPLANES	4
#define  MAXPLANE	5
#define  isAlphaOpaque(x)	((x) >= 255)
#define  isAlphaTransp(x)	((x) < 255)
#define  AlphaOpaque		255
#define  AlphaTransp		0

#ifndef YES
# define  YES	1
# define  NO	0
#endif

enum ns_colorspace {
	CS_White, CS_Black, CS_RGB, CS_CMYK, CS_Other
};

typedef unsigned char	paltype[3];

typedef struct {
	int	width, height;
	short	xbytes;		/* bytes/line */
	unsigned char	bits;
	unsigned char	pixbits;	/* bits/pixel (mesh) */
	unsigned char	numcolors;	/* color elements without alpha */
	unsigned char	isplanar, alpha; /* BOOLean */
        enum ns_colorspace cspace;
} commonInfo;

#endif /* _COMMON_h_ */
